/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.openqa.selenium.AbstractDriverTestCase;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.Ignore;
import org.openqa.selenium.JavascriptEnabled;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.WebElement;

public class VisibilityTest
extends AbstractDriverTestCase {
    @JavascriptEnabled
    public void testShouldAllowTheUserToTellIfAnElementIsDisplayedOrNot() {
        this.driver.get(this.javascriptPage);
        MatcherAssert.assertThat((Object)((RenderedWebElement)this.driver.findElement(By.id((String)"displayed"))).isDisplayed(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((RenderedWebElement)this.driver.findElement(By.id((String)"none"))).isDisplayed(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)((RenderedWebElement)this.driver.findElement(By.id((String)"suppressedParagraph"))).isDisplayed(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)((RenderedWebElement)this.driver.findElement(By.id((String)"hidden"))).isDisplayed(), (Matcher)Is.is((Object)false));
    }

    @JavascriptEnabled
    public void testVisibilityShouldTakeIntoAccountParentVisibility() {
        this.driver.get(this.javascriptPage);
        RenderedWebElement childDiv = (RenderedWebElement)this.driver.findElement(By.id((String)"hiddenchild"));
        RenderedWebElement hiddenLink = (RenderedWebElement)this.driver.findElement(By.id((String)"hiddenlink"));
        VisibilityTest.assertFalse((boolean)childDiv.isDisplayed());
        VisibilityTest.assertFalse((boolean)hiddenLink.isDisplayed());
    }

    @JavascriptEnabled
    public void testShouldCountElementsAsVisibleIfStylePropertyHasBeenSet() {
        this.driver.get(this.javascriptPage);
        RenderedWebElement shown = (RenderedWebElement)this.driver.findElement(By.id((String)"visibleSubElement"));
        VisibilityTest.assertTrue((boolean)shown.isDisplayed());
    }

    @JavascriptEnabled
    public void testShouldModifyTheVisibilityOfAnElementDynamically() {
        this.driver.get(this.javascriptPage);
        RenderedWebElement element = (RenderedWebElement)this.driver.findElement(By.id((String)"hideMe"));
        VisibilityTest.assertTrue((boolean)element.isDisplayed());
        element.click();
        VisibilityTest.assertFalse((boolean)element.isDisplayed());
    }

    @JavascriptEnabled
    public void testHiddenInputElementsAreNeverVisible() {
        this.driver.get(this.javascriptPage);
        RenderedWebElement shown = (RenderedWebElement)this.driver.findElement(By.name((String)"hidden"));
        VisibilityTest.assertFalse((boolean)shown.isDisplayed());
    }

    @JavascriptEnabled
    public void testShouldNotBeAbleToClickOnAnElementThatIsNotDisplayed() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"unclickable"));
        try {
            element.click();
            VisibilityTest.fail((String)"You should not be able to click on an invisible element");
        }
        catch (ElementNotVisibleException elementNotVisibleException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    public void testShouldNotBeAbleToToggleAnElementThatIsNotDisplayed() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"untogglable"));
        try {
            element.toggle();
            VisibilityTest.fail((String)"You should not be able to toggle an invisible element");
        }
        catch (ElementNotVisibleException elementNotVisibleException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    public void testShouldNotBeAbleToSelectAnElementThatIsNotDisplayed() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"untogglable"));
        try {
            element.setSelected();
            VisibilityTest.fail((String)"You should not be able to select an invisible element");
        }
        catch (ElementNotVisibleException elementNotVisibleException) {
            // empty catch block
        }
    }

    @JavascriptEnabled
    public void testShouldNotBeAbleToTypeAnElementThatIsNotDisplayed() {
        this.driver.get(this.javascriptPage);
        WebElement element = this.driver.findElement(By.id((String)"unclickable"));
        try {
            element.sendKeys(new CharSequence[]{"You don't see me"});
            VisibilityTest.fail((String)"You should not be able to send keyboard input to an invisible element");
        }
        catch (ElementNotVisibleException elementNotVisibleException) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)element.getValue(), (Matcher)Is.is((Matcher)Matchers.not((Object)"You don't see me")));
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.HTMLUNIT, Ignore.Driver.IE})
    public void testShouldNotAllowAnElementWithZeroHeightToBeCountedAsDisplayed() {
        this.driver.get(this.javascriptPage);
        RenderedWebElement zeroHeight = (RenderedWebElement)this.driver.findElement(By.id((String)"zeroheight"));
        VisibilityTest.assertFalse((boolean)zeroHeight.isDisplayed());
    }

    @JavascriptEnabled
    @Ignore(value={Ignore.Driver.HTMLUNIT, Ignore.Driver.IE})
    public void testShouldNotAllowAnElementWithZeroWidthToBeCountedAsDisplayed() {
        this.driver.get(this.javascriptPage);
        RenderedWebElement zeroWidth = (RenderedWebElement)this.driver.findElement(By.id((String)"zerowidth"));
        VisibilityTest.assertFalse((boolean)zeroWidth.isDisplayed());
    }
}

