/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.TestCase;
import org.junit.Test;
import org.openqa.selenium.internal.FileHandler;

public class FileHandlerTest
extends TestCase {
    @Test
    public void testUnzip() throws IOException {
        File testZip = this.writeTestZip(File.createTempFile("testUnzip", "zip"), 25);
        File out = FileHandler.unzip((InputStream)new FileInputStream(testZip));
        FileHandlerTest.assertEquals((int)25, (int)out.list().length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCopy() throws IOException {
        File newFile = File.createTempFile("testFileCopy", "dst");
        File tmpFile = this.writeTestFile(File.createTempFile("FileUtilTest", "src"));
        FileHandlerTest.assertTrue((newFile.length() == 0L ? 1 : 0) != 0);
        FileHandlerTest.assertTrue((tmpFile.length() > 0L ? 1 : 0) != 0);
        try {
            FileHandler.copy((File)tmpFile, (File)newFile);
            FileHandlerTest.assertEquals((long)tmpFile.length(), (long)newFile.length());
        }
        finally {
            tmpFile.delete();
            newFile.delete();
        }
    }

    private File writeTestZip(File file, int files) throws IOException {
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(file));
        for (int i = 0; i < files; ++i) {
            this.writeTestZipEntry(out);
        }
        out.close();
        file.deleteOnExit();
        return file;
    }

    private ZipOutputStream writeTestZipEntry(ZipOutputStream out) throws IOException {
        int len;
        File testFile = this.writeTestFile(File.createTempFile("testZip", "file"));
        ZipEntry entry = new ZipEntry(testFile.getName());
        out.putNextEntry(entry);
        FileInputStream in = new FileInputStream(testFile);
        byte[] buffer = new byte[16384];
        while ((len = in.read(buffer, 0, 16384)) != -1) {
            out.write(buffer);
        }
        out.flush();
        return out;
    }

    private File writeTestFile(File file) throws IOException {
        byte[] byteArray = new byte[16384];
        new Random().nextBytes(byteArray);
        FileOutputStream out = new FileOutputStream(file);
        ((OutputStream)out).write(byteArray);
        ((OutputStream)out).close();
        file.deleteOnExit();
        return file;
    }
}

