/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.junit.Test;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.internal.TemporaryFilesystem;

public class TemporaryFilesystemTest
extends TestCase {
    @Test
    public void testCanCreateTempFiles() {
        File tmp = TemporaryFilesystem.createTempDir((String)"TemporaryFilesystem", (String)"canCreate");
        try {
            TemporaryFilesystemTest.assertTrue((boolean)tmp.exists());
        }
        catch (WebDriverException e) {
            tmp.delete();
            throw e;
        }
    }

    @Test
    public void testFilesystemCleanupDeletesDirs() {
        if (!TemporaryFilesystem.shouldReap()) {
            System.out.println("Reaping of files disabled - ignoring testFilesystemCleanupDeletesDirs");
            return;
        }
        File tmp = TemporaryFilesystem.createTempDir((String)"TemporaryFilesystem", (String)"fcdd");
        TemporaryFilesystemTest.assertTrue((boolean)tmp.exists());
        TemporaryFilesystem.deleteTemporaryFiles();
        TemporaryFilesystemTest.assertFalse((boolean)tmp.exists());
    }

    @Test
    public void testFilesystemCleanupDeletesRecursive() throws IOException {
        if (!TemporaryFilesystem.shouldReap()) {
            System.out.println("Reaping of files disabled - ignoring testFilesystemCleanupDeletesRecursive");
            return;
        }
        File tmp = TemporaryFilesystem.createTempDir((String)"TemporaryFilesystem", (String)"fcdr");
        this.createDummyFilesystemContent(tmp);
        TemporaryFilesystem.deleteTemporaryFiles();
        TemporaryFilesystemTest.assertFalse((boolean)tmp.exists());
    }

    @Test
    public void testSpecificDeleteRequestHonored() throws IOException {
        if (!TemporaryFilesystem.shouldReap()) {
            System.out.println("Reaping of files disabled - ignoring testSpecificDeleteRequestHonored");
            return;
        }
        File tmp = TemporaryFilesystem.createTempDir((String)"TemporaryFilesystem", (String)"sdrh");
        this.createDummyFilesystemContent(tmp);
        TemporaryFilesystem.deleteTempDir((File)tmp);
        TemporaryFilesystemTest.assertFalse((boolean)tmp.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoesNotDeleteArbitraryFiles() throws IOException {
        File tempFile = File.createTempFile("TemporaryFilesystem", "dndaf");
        TemporaryFilesystemTest.assertTrue((boolean)tempFile.exists());
        try {
            TemporaryFilesystem.deleteTempDir((File)tempFile);
            TemporaryFilesystemTest.assertTrue((boolean)tempFile.exists());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testShouldReapDefaultsTrue() {
        if (!TemporaryFilesystem.shouldReap()) {
            System.out.println("Reaping of files disabled - ignoring testShouldReapDefaultsTrue");
            return;
        }
        TemporaryFilesystemTest.assertTrue((boolean)TemporaryFilesystem.shouldReap());
    }

    private void createDummyFilesystemContent(File dir) throws IOException {
        TemporaryFilesystemTest.assertTrue((boolean)dir.isDirectory());
        File.createTempFile("cleanup", "file", dir);
        File childDir = new File(dir, "child");
        childDir.mkdir();
        File.createTempFile("cleanup", "childFile", childDir);
    }
}

