/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.IOException;
import java.net.ConnectException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.NotConnectedException;
import org.openqa.selenium.firefox.ProfileManager;
import org.openqa.selenium.firefox.internal.RunningInstanceConnection;

public class FirefoxLauncher {
    private final FirefoxBinary binary;

    public FirefoxLauncher(FirefoxBinary binary) {
        this.binary = binary;
    }

    public static void main(String[] args) {
        FirefoxBinary binary = new FirefoxBinary();
        FirefoxLauncher launcher = new FirefoxLauncher(new FirefoxBinary());
        String profileName = "WebDriver";
        int port = 7055;
        if (args.length >= 2) {
            port = Integer.parseInt(args[1]);
        }
        if (args.length >= 1) {
            profileName = args[0];
        }
        launcher.connectAndKill(port);
        launcher.createBaseWebDriverProfile(binary, profileName, port);
        launcher.repeatedlyConnectUntilFirefoxAppearsStable(port);
    }

    public FirefoxBinary startProfile(FirefoxProfile profile, int port) throws IOException {
        FirefoxBinary binaryToUse = this.binary;
        if (this.binary == null) {
            binaryToUse = new FirefoxBinary();
        }
        FirefoxProfile profileToUse = profile.createCopy(port);
        binaryToUse.clean(profileToUse);
        binaryToUse.startProfile(profileToUse, new String[0]);
        return binaryToUse;
    }

    @Deprecated
    public void createBaseWebDriverProfile(FirefoxBinary binary, String profileName, int port) {
        this.connectAndKill(port);
        System.out.println(String.format("Creating %s", profileName));
        try {
            binary.createProfile(profileName);
            System.out.println("Profile created");
            binary.waitFor();
        }
        catch (IOException e) {
            throw new WebDriverException("Unable to create base webdriver profile", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
        ProfileManager.getInstance().createProfile(binary, profileName, port);
    }

    @Deprecated
    protected void connectAndKill(int port) {
        try {
            RunningInstanceConnection connection = new RunningInstanceConnection("localhost", port, 5000L);
            connection.quit();
        }
        catch (ConnectException e) {
        }
        catch (NotConnectedException e) {
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private void repeatedlyConnectUntilFirefoxAppearsStable(int port) {
        long maxWaitTime = System.currentTimeMillis() + this.binary.getTimeout();
        do {
            try {
                RunningInstanceConnection connection = new RunningInstanceConnection("localhost", port, 1000L);
                Thread.sleep(2000L);
                connection.quit();
                return;
            }
            catch (ConnectException e) {
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                throw new WebDriverException((Throwable)e);
            }
        } while (System.currentTimeMillis() < maxWaitTime);
    }
}

