/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;

public class ProfileManager {
    private static final String ANONYMOUS_PROFILE_NAME = "WEBDRIVER_ANONYMOUS_PROFILE";
    private static final ProfileManager SINGLETON = new ProfileManager();
    private final Map<String, FirefoxProfile> cachedProfiles = new ConcurrentHashMap<String, FirefoxProfile>();

    public static final synchronized ProfileManager getInstance() {
        return SINGLETON;
    }

    private ProfileManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FirefoxProfile createProfile(FirefoxBinary binary, int port) {
        FirefoxProfile anonymous = this.cachedProfiles.get(ANONYMOUS_PROFILE_NAME);
        if (!ProfileManager.isValidProfile(anonymous)) {
            ProfileManager profileManager = this;
            synchronized (profileManager) {
                anonymous = this.cachedProfiles.get(ANONYMOUS_PROFILE_NAME);
                if (!ProfileManager.isValidProfile(anonymous)) {
                    anonymous = new FirefoxProfile(){

                        public void clean() {
                            throw new WebDriverException("Cached profiles must not be cleaed.");
                        }
                    };
                    ProfileManager.initCachedProfile(binary, anonymous, port);
                    this.cachedProfiles.put(ANONYMOUS_PROFILE_NAME, anonymous);
                }
            }
        }
        return anonymous.createCopy(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FirefoxProfile createProfile(FirefoxBinary binary, String profileName, int port) {
        FirefoxProfile named = this.cachedProfiles.get(profileName);
        if (!ProfileManager.isValidProfile(named)) {
            ProfileManager profileManager = this;
            synchronized (profileManager) {
                named = this.cachedProfiles.get(profileName);
                if (!ProfileManager.isValidProfile(named)) {
                    ProfilesIni profileDirectory = new ProfilesIni();
                    named = profileDirectory.getProfile(profileName);
                    if (!ProfileManager.isValidProfile(named)) {
                        throw new WebDriverException(String.format("Unable to locate profile \"%s\"", profileName));
                    }
                    ProfileManager.initCachedProfile(binary, named, port);
                    this.cachedProfiles.put(profileName, named);
                }
            }
        }
        return named.createCopy(port);
    }

    private static boolean isValidProfile(FirefoxProfile profile) {
        return profile != null && profile.getProfileDir().exists();
    }

    private static void initCachedProfile(FirefoxBinary binary, FirefoxProfile profile, int port) {
        profile.addWebDriverExtensionIfNeeded(false);
        profile.setPort(port);
        profile.updateUserPrefs();
        try {
            binary.clean(profile);
        }
        catch (IOException e) {
            throw new WebDriverException("Unable to clean profile", (Throwable)e);
        }
    }
}

