/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.Command;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxLauncher;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.AbstractExtensionConnection;
import org.openqa.selenium.firefox.internal.CircularOutputStream;
import org.openqa.selenium.firefox.internal.Lock;

public class NewProfileExtensionConnection
extends AbstractExtensionConnection {
    private FirefoxBinary process;
    private FirefoxProfile profile;
    private int bufferSize = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NewProfileExtensionConnection(Lock lock, FirefoxBinary binary, FirefoxProfile profile, String host) throws IOException {
        this.profile = profile;
        lock.lock(binary.getTimeout());
        try {
            int portToUse = this.determineNextFreePort(host, profile.getPort());
            binary.setOutputWatcher(new CircularOutputStream(this.bufferSize));
            this.process = new FirefoxLauncher(binary).startProfile(profile, portToUse);
            this.setAddress(host, portToUse);
            this.connectToBrowser(binary.getTimeout());
        }
        finally {
            lock.unlock();
        }
    }

    protected void connectToBrowser(long timeToWaitInMilliSeconds) throws IOException {
        try {
            super.connectToBrowser(timeToWaitInMilliSeconds);
        }
        catch (IOException e) {
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), this.profile.getPort(), this.process.getConsoleOutput()), (Throwable)e);
        }
        catch (WebDriverException e) {
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: \n%s", this.process.toString(), this.profile.getPort(), this.process.getConsoleOutput()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int determineNextFreePort(String host, int port) throws IOException {
        int newport;
        for (newport = port; newport < port + 200; ++newport) {
            Socket socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(host, newport);
            try {
                socket.bind(address);
                int n = newport;
                return n;
            }
            catch (BindException e) {
                continue;
            }
            finally {
                socket.close();
            }
        }
        throw new WebDriverException(String.format("Cannot find free port in the range %d to %d ", port, newport));
    }

    public void quit() {
        try {
            this.sendMessageAndWaitForResponse(WebDriverException.class, new Command(null, "quit", new Object[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Platform.getCurrent().is(Platform.WINDOWS)) {
            this.quitOnWindows();
        } else {
            this.quitOnOtherPlatforms();
        }
        this.profile.clean();
    }

    private void quitOnOtherPlatforms() {
        try {
            this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private void quitOnWindows() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            throw new WebDriverException((Throwable)e);
        }
    }
}

