/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.remote.MapMaker;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteWebElement
implements WebElement,
SearchContext,
FindsByLinkText,
FindsById,
FindsByName,
FindsByClassName,
FindsByXPath {
    protected String id;
    protected RemoteWebDriver parent;

    public void setParent(RemoteWebDriver parent) {
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void click() {
        this.execute("clickElement", MapMaker.map("id", this.id));
    }

    public void submit() {
        this.execute("submitElement", MapMaker.map("id", this.id));
    }

    public String getValue() {
        return (String)this.execute("getElementValue", MapMaker.map("id", this.id)).getValue();
    }

    public void sendKeys(CharSequence ... keysToSend) {
        this.execute("sendKeys", MapMaker.map("id", this.id, "value", keysToSend));
    }

    public void clear() {
        this.execute("clearElement", MapMaker.map("id", this.id));
    }

    public String getTagName() {
        return (String)this.execute("getTagName", MapMaker.map("id", this.id)).getValue();
    }

    public String getElementName() {
        return this.getTagName();
    }

    public String getAttribute(String name) {
        Object value = this.execute("getElementAttribute", MapMaker.map("id", this.id, "name", name)).getValue();
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public boolean toggle() {
        return (Boolean)this.execute("toggleElement", MapMaker.map("id", this.id)).getValue();
    }

    public boolean isSelected() {
        return (Boolean)this.execute("isElementSelected", MapMaker.map("id", this.id)).getValue();
    }

    public void setSelected() {
        this.execute("setElementSelected", MapMaker.map("id", this.id));
    }

    public boolean isEnabled() {
        return (Boolean)this.execute("isElementEnabled", MapMaker.map("id", this.id)).getValue();
    }

    public String getText() {
        Response response = this.execute("getElementText", MapMaker.map("id", this.id));
        return (String)response.getValue();
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public WebElement findElementById(String using) {
        Response response = this.execute("findElementUsingElement", MapMaker.map("id", this.id, "using", "id", "value", using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsById(String using) {
        Response response = this.execute("findElementsUsingElement", MapMaker.map("id", this.id, "using", "id", "value", using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByLinkText(String using) {
        Response response = this.execute("findElementUsingElement", MapMaker.map("id", this.id, "using", "link text", "value", using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        Response response = this.execute("findElementsUsingElement", MapMaker.map("id", this.id, "using", "link text", "value", using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByName(String using) {
        Response response = this.execute("findElementUsingElement", MapMaker.map("id", this.id, "using", "name", "value", using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByName(String using) {
        Response response = this.execute("findElementsUsingElement", MapMaker.map("id", this.id, "using", "name", "value", using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByClassName(String using) {
        Response response = this.execute("findElementUsingElement", MapMaker.map("id", this.id, "using", "class name", "value", using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByClassName(String using) {
        Response response = this.execute("findElementsUsingElement", MapMaker.map("id", this.id, "using", "class name", "value", using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByXPath(String using) {
        Response response = this.execute("findElementUsingElement", MapMaker.map("id", this.id, "using", "xpath", "value", using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByXPath(String using) {
        Response response = this.execute("findElementsUsingElement", MapMaker.map("id", this.id, "using", "xpath", "value", using));
        return this.getElementsFrom(response);
    }

    public WebElement findElementByPartialLinkText(String using) {
        Response response = this.execute("findElementUsingElement", MapMaker.map("id", this.id, "using", "partial link text", "value", using));
        return this.getElementFrom(response);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        Response response = this.execute("findElementsUsingElement", MapMaker.map("id", this.id, "using", "partial link text", "value", using));
        return this.getElementsFrom(response);
    }

    protected Response execute(String commandName, Object ... parameters) {
        return this.parent.execute(commandName, parameters);
    }

    protected WebElement getElementFrom(Response response) {
        return this.parent.getElementFrom(response);
    }

    protected List<WebElement> getElementsFrom(Response response) {
        return this.parent.getElementsFrom(response);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        if (other instanceof WrapsElement) {
            other = ((WrapsElement)obj).getWrappedElement();
        }
        if (!(other instanceof RemoteWebElement)) {
            return false;
        }
        Response response = this.execute("equals", MapMaker.map("id", this.id, "other", ((RemoteWebElement)other).id));
        Object value = response.getValue();
        return value != null && value instanceof Boolean && (Boolean)value != false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

