/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.crawler.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.ontoware.rdf2go.model.node.URI;
import org.semanticdesktop.aperture.crawler.CrawlerFactory;
import org.semanticdesktop.aperture.crawler.CrawlerRegistry;

public class CrawlerRegistryImpl
implements CrawlerRegistry {
    private HashMap factories = new HashMap();

    public void add(CrawlerFactory crawlerFactory) {
        if (crawlerFactory == null) {
            throw new IllegalArgumentException("factory is not allowed to be null");
        }
        for (URI uRI : crawlerFactory.getSupportedTypes()) {
            HashSet<CrawlerFactory> hashSet = (HashSet<CrawlerFactory>)this.factories.get(uRI);
            if (hashSet == null) {
                hashSet = new HashSet<CrawlerFactory>();
                this.factories.put(uRI, hashSet);
            }
            hashSet.add(crawlerFactory);
        }
    }

    public void remove(CrawlerFactory crawlerFactory) {
        for (URI uRI : crawlerFactory.getSupportedTypes()) {
            Set set = (Set)this.factories.get(uRI);
            if (set == null) continue;
            set.remove(crawlerFactory);
            if (!set.isEmpty()) continue;
            this.factories.remove(uRI);
        }
    }

    public Set get(URI uRI) {
        Set set = (Set)this.factories.get(uRI);
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return new HashSet(set);
    }

    public Set getAll() {
        HashSet hashSet = new HashSet();
        for (Set set : this.factories.values()) {
            hashSet.addAll(set);
        }
        return hashSet;
    }
}

