/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.mime;

import java.util.Date;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.ontoware.rdf2go.exception.ModelException;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Literal;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NMO;

public class MailUtil {
    public static void getDates(Message message, RDFContainer rDFContainer) throws MessagingException {
        Date date;
        Date date2 = message.getSentDate();
        if (date2 != null) {
            rDFContainer.add(NMO.sentDate, date2);
        }
        if ((date = message.getReceivedDate()) != null) {
            rDFContainer.add(NMO.receivedDate, date);
        }
        if (date2 == null && date == null) {
            rDFContainer.add(NMO.receivedDate, new Date());
        }
    }

    public static void addAddressMetadata(InternetAddress internetAddress, URI uRI, RDFContainer rDFContainer) throws ModelException {
        String string;
        String string2 = internetAddress.getPersonal();
        if (string2 != null) {
            string2 = string2.trim();
        }
        if ((string = internetAddress.getAddress()) != null) {
            string = string.trim();
        }
        if (MailUtil.hasRealValue(string2) || MailUtil.hasRealValue(string)) {
            Literal literal;
            Model model = rDFContainer.getModel();
            URI uRI2 = model.createURI(MailUtil.getPersonURI(string, string2));
            model.addStatement((Resource)uRI2, RDF.type, (Node)NCO.Contact);
            if (MailUtil.hasRealValue(string2)) {
                literal = rDFContainer.getValueFactory().createLiteral(string2);
                model.addStatement((Resource)uRI2, NCO.fullname, (Node)literal);
            }
            if (MailUtil.hasRealValue(string)) {
                literal = rDFContainer.getValueFactory().createLiteral(string);
                Resource resource = UriUtil.generateRandomResource(model);
                model.addStatement((Resource)uRI2, NCO.hasEmailAddress, (Node)resource);
                model.addStatement(resource, RDF.type, (Node)NCO.EmailAddress);
                model.addStatement(resource, NCO.emailAddress, (Node)literal);
            }
            rDFContainer.add(uRI, (Node)uRI2);
        }
    }

    public static String getPersonURI(String string, String string2) throws IllegalArgumentException {
        if (MailUtil.hasRealValue(string)) {
            return "email:" + string;
        }
        if (MailUtil.hasRealValue(string2)) {
            return "emailperson:" + string2;
        }
        throw new IllegalArgumentException("no valid email or name, email = " + string + ", name = " + string2);
    }

    private static boolean hasRealValue(String string) {
        return string != null && string.length() > 0;
    }
}

