/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.mp3;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.ontoware.rdf2go.model.Model;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.Resource;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.AbstractFileExtractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.mp3.FrameIdentifier;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.UriUtil;
import org.semanticdesktop.aperture.vocabulary.NCO;
import org.semanticdesktop.aperture.vocabulary.NID3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MP3FileExtractor
extends AbstractFileExtractor {
    private Logger logger = LoggerFactory.getLogger(MP3FileExtractor.class);

    @Override
    protected void performExtraction(URI uRI, File file, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        MP3File mP3File = null;
        try {
            mP3File = new MP3File(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ExtractorException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
        catch (TagException tagException) {
            throw new ExtractorException("File format not supported by the MP3Exctractor: " + file.getParent(), tagException);
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            throw new ExtractorException(readOnlyFileException);
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            throw new ExtractorException(invalidAudioFrameException);
        }
        HashMap<URI, String> hashMap = new HashMap<URI, String>();
        if (mP3File.hasID3v1Tag()) {
            this.processID3V1Tags(uRI, mP3File, charset, string, hashMap);
        }
        if (mP3File.hasID3v2Tag()) {
            this.processID3V2Tags(uRI, mP3File, charset, string, hashMap, rDFContainer);
        }
        this.addId3V1Fields(hashMap, rDFContainer);
        rDFContainer.add(RDF.type, (Node)NID3.ID3Audio);
    }

    private void processID3V1Tags(URI uRI, MP3File mP3File, Charset charset, String string, HashMap<URI, String> hashMap) {
        ID3v1Tag iD3v1Tag = mP3File.getID3v1Tag();
        this.addStringProperty(NID3.title, iD3v1Tag.getFirstTitle(), hashMap);
        this.addStringProperty(NID3.leadArtist, iD3v1Tag.getFirstArtist(), hashMap);
        this.addStringProperty(NID3.albumTitle, iD3v1Tag.getFirstAlbum(), hashMap);
        this.addStringProperty(NID3.recordingYear, iD3v1Tag.getFirstYear(), hashMap);
        this.addStringProperty(NID3.comments, iD3v1Tag.getFirstComment(), hashMap);
        this.addStringProperty(NID3.contentType, iD3v1Tag.getFirstGenre(), hashMap);
        if (iD3v1Tag instanceof ID3v11Tag) {
            ID3v11Tag iD3v11Tag = (ID3v11Tag)iD3v1Tag;
            this.addStringProperty(NID3.trackNumber, iD3v11Tag.getFirstTrack(), hashMap);
        }
    }

    private void processID3V2Tags(URI uRI, MP3File mP3File, Charset charset, String string, HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
        AbstractID3v2Tag abstractID3v2Tag = mP3File.getID3v2Tag();
        Iterator iterator = abstractID3v2Tag.getFields();
        while (iterator.hasNext()) {
            AbstractID3v2Frame abstractID3v2Frame = (AbstractID3v2Frame)iterator.next();
            String string2 = abstractID3v2Frame.getIdentifier();
            try {
                FrameIdentifier frameIdentifier = FrameIdentifier.valueOf(string2.trim());
                AbstractTagFrameBody abstractTagFrameBody = abstractID3v2Frame.getBody();
                frameIdentifier.process(abstractTagFrameBody, abstractID3v2Tag, hashMap, rDFContainer);
            }
            catch (Exception exception) {
                this.logger.warn("Problem while getting the frame '" + string2 + "' from file " + uRI, (Throwable)exception);
            }
        }
    }

    private void addStringProperty(URI uRI, String string, HashMap<URI, String> hashMap) {
        if (string != null && string.length() > 0) {
            hashMap.put(uRI, string);
        }
    }

    private void addId3V1Fields(HashMap<URI, String> hashMap, RDFContainer rDFContainer) {
        for (URI uRI : hashMap.keySet()) {
            String string = hashMap.get(uRI);
            if (uRI.equals(NID3.recordingYear)) {
                try {
                    int n = Integer.parseInt(string);
                    rDFContainer.add(uRI, n);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (uRI.equals(NID3.leadArtist)) {
                Model model = rDFContainer.getModel();
                Resource resource = UriUtil.generateRandomResource(model);
                model.addStatement((Resource)rDFContainer.getDescribedUri(), NID3.leadArtist, (Node)resource);
                model.addStatement(resource, RDF.type, (Node)NCO.Contact);
                model.addStatement(resource, NCO.fullname, string);
                continue;
            }
            rDFContainer.add(uRI, string);
        }
    }
}

