/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.extractor.quattro;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.ontoware.rdf2go.model.node.Node;
import org.ontoware.rdf2go.model.node.URI;
import org.ontoware.rdf2go.vocabulary.RDF;
import org.semanticdesktop.aperture.extractor.Extractor;
import org.semanticdesktop.aperture.extractor.ExtractorException;
import org.semanticdesktop.aperture.extractor.util.PoiUtil;
import org.semanticdesktop.aperture.rdf.RDFContainer;
import org.semanticdesktop.aperture.util.IOUtil;
import org.semanticdesktop.aperture.vocabulary.NFO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuattroExtractor
implements Extractor {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final byte[] MAGIC_BYTES = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};

    public void extract(URI uRI, InputStream inputStream, Charset charset, String string, RDFContainer rDFContainer) throws ExtractorException {
        try {
            if (!inputStream.markSupported()) {
                inputStream = new BufferedInputStream(inputStream, MAGIC_BYTES.length);
            }
            if (this.hasMSOfficeMagicNumber(inputStream)) {
                PoiUtil.extractAll(inputStream, null, rDFContainer, this.logger);
            }
            rDFContainer.add(RDF.type, (Node)NFO.Spreadsheet);
        }
        catch (IOException iOException) {
            throw new ExtractorException(iOException);
        }
    }

    private boolean hasMSOfficeMagicNumber(InputStream inputStream) throws IOException {
        int n = MAGIC_BYTES.length;
        inputStream.mark(n);
        byte[] byArray = IOUtil.readBytes(inputStream, n);
        inputStream.reset();
        return Arrays.equals(byArray, MAGIC_BYTES);
    }
}

