/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.mime.identifier.magic;

import java.util.ArrayList;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicNumber;
import org.semanticdesktop.aperture.mime.identifier.magic.MagicString;

public class MimeTypeDescription {
    private String mimeType;
    private String parentType;
    private ArrayList extensions;
    private ArrayList magicStrings;
    private ArrayList magicNumbers;
    private boolean allowsLeadingWhiteSpace;
    private ArrayList requiringTypes;

    public MimeTypeDescription(String string, String string2, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, boolean bl) {
        this.mimeType = string;
        this.parentType = string2;
        this.extensions = arrayList;
        this.magicStrings = arrayList2;
        this.magicNumbers = arrayList3;
        this.allowsLeadingWhiteSpace = bl;
        this.requiringTypes = new ArrayList(0);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getParentType() {
        return this.parentType;
    }

    public ArrayList getExtensions() {
        return this.extensions;
    }

    public ArrayList getMagicStrings() {
        return this.magicStrings;
    }

    public ArrayList getMagicNumbers() {
        return this.magicNumbers;
    }

    public boolean getAllowsLeadingWhiteSpace() {
        return this.allowsLeadingWhiteSpace;
    }

    public void addRequiringType(MimeTypeDescription mimeTypeDescription) {
        this.requiringTypes.add(mimeTypeDescription);
    }

    public ArrayList getRequiringTypes() {
        return this.requiringTypes;
    }

    public boolean matches(char[] cArray) {
        if (cArray != null && this.magicStrings != null && !this.magicStrings.isEmpty()) {
            int n;
            int n2;
            int n3 = 0;
            if (this.allowsLeadingWhiteSpace) {
                for (n2 = 0; n2 < cArray.length && Character.isWhitespace((char)(n = cArray[n2])); ++n2) {
                    ++n3;
                }
            }
            n2 = this.magicStrings.size();
            for (n = 0; n < n2; ++n) {
                MagicString magicString = (MagicString)this.magicStrings.get(n);
                if (!magicString.matches(cArray, n3)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean matches(byte[] byArray) {
        if (byArray != null && this.magicNumbers != null && !this.magicNumbers.isEmpty()) {
            int n;
            int n2;
            int n3 = 0;
            if (this.allowsLeadingWhiteSpace) {
                for (n2 = 0; n2 < byArray.length && (Character.isWhitespace((char)(n = (int)((char)byArray[n2]))) || n == 0 || n == 255 || n == 254 || n == 239 || n == 187 || n == 191); ++n2) {
                    ++n3;
                }
            }
            n2 = this.magicNumbers.size();
            for (n = 0; n < n2; ++n) {
                MagicNumber magicNumber = (MagicNumber)this.magicNumbers.get(n);
                if (!magicNumber.matches(byArray, n3)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsExtension(String string) {
        return this.extensions.contains(string);
    }
}

