/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ArrayMap
implements Map {
    private Object[] keys;
    private Object[] values;
    private int size;
    private int modCount;

    public ArrayMap() {
        this(0);
    }

    public ArrayMap(int n) {
        this.keys = new Object[n];
        this.values = new Object[n];
        this.size = 0;
        this.modCount = 0;
    }

    public ArrayMap(Map map) {
        this.size = map.size();
        this.keys = new Object[this.size];
        this.values = new Object[this.size];
        Iterator iterator = map.entrySet().iterator();
        for (int i = 0; i < this.size; ++i) {
            Map.Entry entry = iterator.next();
            this.keys[i] = entry.getKey();
            this.values[i] = entry.getValue();
        }
        this.modCount = 0;
    }

    public void clear() {
        this.keys = new Object[0];
        this.values = new Object[0];
        this.size = 0;
        ++this.modCount;
    }

    public boolean containsKey(Object object) {
        return this.indexOf(object, this.keys, this.size) != -1;
    }

    public boolean containsValue(Object object) {
        return this.indexOf(object, this.values, this.size) != -1;
    }

    public Set entrySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new EntryIterator();
            }

            public int size() {
                return ArrayMap.this.size;
            }

            public boolean contains(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    int n = ArrayMap.this.indexOf(entry.getKey(), ArrayMap.this.keys, ArrayMap.this.size);
                    return n != -1 && ArrayMap.this.values[n] == entry.getValue();
                }
                return false;
            }

            public boolean remove(Object object) {
                Map.Entry entry;
                int n;
                if (object instanceof Map.Entry && (n = ArrayMap.this.indexOf((entry = (Map.Entry)object).getKey(), ArrayMap.this.keys, ArrayMap.this.size)) != -1 && ArrayMap.this.values[n] == entry.getValue()) {
                    ArrayMap.this.remove(n);
                    return true;
                }
                return false;
            }

            public void clear() {
                ArrayMap.this.clear();
            }
        };
    }

    public boolean equals(Object object) {
        if (object instanceof Map) {
            Set set = ((Map)object).entrySet();
            return ((Object)this.entrySet()).equals(set);
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        Iterator iterator = this.entrySet().iterator();
        boolean bl = iterator.hasNext();
        while (bl) {
            Entry entry = (Entry)iterator.next();
            Object object = entry.getKey();
            if (object == this) {
                stringBuilder.append("(this Map)");
            } else {
                stringBuilder.append(object);
            }
            stringBuilder.append('=');
            Object object2 = entry.getValue();
            if (object2 == this) {
                stringBuilder.append("(this Map)");
            } else {
                stringBuilder.append(object2);
            }
            if (!(bl = iterator.hasNext())) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Object get(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (this.keys[i] != object) continue;
            return this.values[i];
        }
        return null;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            Object object = this.keys[i];
            Object object2 = this.values[i];
            int n2 = object == null ? 0 : object.hashCode();
            int n3 = object2 == null ? 0 : object2.hashCode();
            n = (int)((double)n + Math.pow(n2, n3));
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Set keySet() {
        return new AbstractSet(){

            public Iterator iterator() {
                return new KeyIterator();
            }

            public int size() {
                return ArrayMap.this.size;
            }

            public boolean contains(Object object) {
                return ArrayMap.this.containsKey(object);
            }

            public boolean remove(Object object) {
                int n = ArrayMap.this.size;
                ArrayMap.this.remove(object);
                return ArrayMap.this.size != n;
            }

            public void clear() {
                ArrayMap.this.clear();
            }
        };
    }

    public Object put(Object object, Object object2) {
        Object object3 = null;
        int n = this.indexOf(object, this.keys, this.size);
        if (n == -1) {
            if (this.keys.length == this.size) {
                this.keys = this.toLargerArray(this.keys);
                this.values = this.toLargerArray(this.values);
            }
            this.keys[this.size] = object;
            this.values[this.size] = object2;
            ++this.size;
        } else {
            object3 = this.values[n];
            this.values[n] = object2;
        }
        ++this.modCount;
        return object3;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        int n = this.indexOf(object, this.keys, this.size);
        if (n == -1) {
            return null;
        }
        Object object2 = this.values[n];
        this.remove(n);
        return object2;
    }

    public int size() {
        return this.size;
    }

    public Collection values() {
        return new AbstractCollection(){

            public Iterator iterator() {
                return new ValueIterator();
            }

            public int size() {
                return ArrayMap.this.size;
            }

            public boolean contains(Object object) {
                for (int i = 0; i < ArrayMap.this.size; ++i) {
                    if (ArrayMap.this.values[i] != object) continue;
                    return true;
                }
                return false;
            }

            public boolean remove(Object object) {
                int n = ArrayMap.this.indexOf(object, ArrayMap.this.values, ArrayMap.this.size);
                if (n == -1) {
                    return false;
                }
                ArrayMap.this.remove(n);
                return true;
            }

            public void clear() {
                ArrayMap.this.clear();
            }
        };
    }

    public Object getKey(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("invalid index: " + n + ", size=" + this.size);
        }
        return this.keys[n];
    }

    public Object getValue(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("invalid index: " + n + ", size=" + this.size);
        }
        return this.values[n];
    }

    private Object[] toLargerArray(Object[] objectArray) {
        int n = objectArray.length;
        Object[] objectArray2 = new Object[n + 1];
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    private int indexOf(Object object, Object[] objectArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (objectArray[i] != object) continue;
            return i;
        }
        return -1;
    }

    private void remove(int n) {
        int n2 = n + 1;
        int n3 = this.size - n2;
        System.arraycopy(this.keys, n2, this.keys, n, n3);
        System.arraycopy(this.values, n2, this.values, n, n3);
        --this.size;
        this.keys[this.size] = null;
        this.values[this.size] = null;
        ++this.modCount;
    }

    private class ValueIterator
    extends ArrayIterator {
        public ValueIterator() {
            super(ArrayMap.this.values, ArrayMap.this.size);
        }
    }

    private class KeyIterator
    extends ArrayIterator {
        public KeyIterator() {
            super(ArrayMap.this.keys, ArrayMap.this.size);
        }
    }

    private class ArrayIterator
    implements Iterator {
        private Object[] array;
        private int length;
        private int index;
        private int expectedModCount;

        public ArrayIterator(Object[] objectArray, int n) {
            this.array = objectArray;
            this.length = n;
            this.index = 0;
            this.expectedModCount = ArrayMap.this.modCount;
        }

        public boolean hasNext() {
            return this.index < this.length;
        }

        public Object next() {
            if (this.index >= this.length) {
                throw new NoSuchElementException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Object object = this.array[this.index];
            ++this.index;
            return object;
        }

        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ArrayMap.this.remove(this.index - 1);
            --this.length;
            ++this.expectedModCount;
        }
    }

    private class EntryIterator
    implements Iterator {
        private int index = 0;
        private int expectedModCount;

        public EntryIterator() {
            this.expectedModCount = ArrayMap.this.modCount;
        }

        public boolean hasNext() {
            return this.index < ArrayMap.this.size;
        }

        public Object next() {
            if (this.index >= ArrayMap.this.size) {
                throw new NoSuchElementException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            Entry entry = new Entry(this.index);
            ++this.index;
            return entry;
        }

        public void remove() {
            if (this.index == 0) {
                throw new IllegalStateException();
            }
            if (ArrayMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            ArrayMap.this.remove(this.index - 1);
            ++this.expectedModCount;
        }
    }

    public class Entry
    implements Map.Entry {
        private int index;

        public Entry(int n) {
            this.index = n;
        }

        public Object getKey() {
            return ArrayMap.this.keys[this.index];
        }

        public Object getValue() {
            return ArrayMap.this.values[this.index];
        }

        public Object setValue(Object object) {
            Object object2 = ArrayMap.this.values[this.index];
            ((ArrayMap)ArrayMap.this).values[this.index] = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                boolean bl;
                Map.Entry entry = (Map.Entry)object;
                boolean bl2 = ArrayMap.this.keys[this.index] == null ? entry.getKey() == null : (bl = ArrayMap.this.keys[this.index] == entry.getKey());
                boolean bl3 = ArrayMap.this.values[this.index] == null ? entry.getValue() == null : ArrayMap.this.values[this.index] == entry.getValue();
                return bl && bl3;
            }
            return false;
        }

        public int hashCode() {
            Object object = ArrayMap.this.keys[this.index];
            Object object2 = ArrayMap.this.values[this.index];
            int n = object == null ? 0 : object.hashCode();
            int n2 = object2 == null ? 0 : object2.hashCode();
            return (int)Math.pow(n, n2);
        }
    }
}

