/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticdesktop.aperture.util.SimpleSAXListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleSAXParser {
    private SAXParser saxParser;
    private SimpleSAXListener listener;
    private boolean trimWhitespace = true;

    public SimpleSAXParser(SAXParser sAXParser) {
        this.saxParser = sAXParser;
    }

    public SimpleSAXParser() throws ParserConfigurationException, SAXException {
        this(SAXParserFactory.newInstance().newSAXParser());
    }

    public void setListener(SimpleSAXListener simpleSAXListener) {
        this.listener = simpleSAXListener;
    }

    public SimpleSAXListener getListener() {
        return this.listener;
    }

    public void setTrimWhiteSpace(boolean bl) {
        this.trimWhitespace = bl;
    }

    public boolean getTrimWhitespace() {
        return this.trimWhitespace;
    }

    public synchronized void parse(InputStream inputStream) throws SAXException, IOException {
        this.saxParser.parse(inputStream, (DefaultHandler)new SimpleSAXDefaultHandler());
    }

    public synchronized void parse(InputStream inputStream, String string) throws SAXException, IOException {
        this.saxParser.parse(inputStream, new SimpleSAXDefaultHandler(), string);
    }

    public synchronized void parse(File file) throws SAXException, IOException {
        this.saxParser.parse(file, (DefaultHandler)new SimpleSAXDefaultHandler());
    }

    private class SimpleSAXDefaultHandler
    extends DefaultHandler {
        private StringBuilder charBuf = new StringBuilder(512);
        private String deferredStartTag = null;
        private Map deferredAttributes = null;

        public void startDocument() throws SAXException {
            SimpleSAXParser.this.listener.startDocument();
        }

        public void endDocument() throws SAXException {
            SimpleSAXParser.this.listener.endDocument();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.charBuf.append(cArray, n, n2);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.deferredStartTag != null) {
                this.reportDeferredStartElement();
            }
            this.deferredStartTag = string3;
            int n = attributes.getLength();
            if (n == 0) {
                this.deferredAttributes = Collections.EMPTY_MAP;
            } else {
                this.deferredAttributes = new HashMap(n * 2);
                for (int i = 0; i < n; ++i) {
                    this.deferredAttributes.put(attributes.getQName(i), attributes.getValue(i));
                }
            }
            this.charBuf.setLength(0);
        }

        private void reportDeferredStartElement() throws SAXException {
            SimpleSAXParser.this.listener.startTag(this.deferredStartTag, this.deferredAttributes, "");
            this.deferredStartTag = null;
            this.deferredAttributes = null;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.deferredStartTag != null) {
                String string4 = this.charBuf.toString();
                if (SimpleSAXParser.this.trimWhitespace) {
                    string4 = string4.trim();
                }
                SimpleSAXParser.this.listener.startTag(this.deferredStartTag, this.deferredAttributes, string4);
                this.deferredStartTag = null;
                this.deferredAttributes = null;
            }
            SimpleSAXParser.this.listener.endTag(string3);
            this.charBuf.setLength(0);
        }
    }
}

