/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tag
extends AbstractMap<String, String>
implements Comparable<Tag>,
Map<String, String> {
    public static final Logger log = LoggerFactory.getLogger(Tag.class);
    private Set<Map.Entry<String, String>> mapSet = null;
    private String uri;
    private String name;
    private String description;
    private String classUri;
    private String className;

    public Tag(Map<String, String> map) {
        this.putAll(map);
    }

    public Tag(String string, String string2, String string3) {
        this.uri = string;
        this.name = string2;
        this.classUri = string3;
        this.description = "";
    }

    public Tag(String string, String string2, String string3, String string4) {
        this.uri = string;
        this.name = string2;
        this.classUri = string3;
        this.className = string4;
        this.description = "";
    }

    @Override
    public int hashCode() {
        if (this.uri != null) {
            return this.uri.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Tag) {
            Tag tag = (Tag)object;
            return tag.getUri().equals(this.getUri());
        }
        return false;
    }

    public String getUri() {
        return this.uri;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassUri() {
        return this.classUri;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[(name," + this.name + ")");
        stringBuffer.append("(uri," + this.uri + ")");
        stringBuffer.append("(class," + this.classUri + ")]");
        return stringBuffer.toString();
    }

    @Override
    public int compareTo(Tag tag) {
        if (this.equals(tag)) {
            return 0;
        }
        int n = this.getName().compareTo(tag.getName());
        if (n != 0) {
            return n;
        }
        n = this.getUri().compareTo(tag.getUri());
        return n;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        if (this.mapSet == null) {
            this.mapSet = new TreeSet<Map.Entry<String, String>>();
            if (this.getUri() != null) {
                this.mapSet.add(new TagEntryEntry("uri", this.getUri()));
            }
            if (this.getName() != null) {
                this.mapSet.add(new TagEntryEntry("name", this.getName()));
            }
            if (this.getDescription() != null) {
                this.mapSet.add(new TagEntryEntry("description", this.getDescription()));
            }
            if (this.getClassUri() != null) {
                this.mapSet.add(new TagEntryEntry("classuri", this.getClassUri()));
            }
            if (this.getClassName() != null) {
                this.mapSet.add(new TagEntryEntry("classname", this.getClassName()));
            }
        }
        return this.mapSet;
    }

    @Override
    public String put(String string, String string2) {
        if ("uri".equals(string)) {
            this.uri = string2;
        } else if ("name".equals(string)) {
            this.name = string2;
        } else if ("description".equals(string)) {
            this.description = string2;
        } else if ("classuri".equals(string)) {
            this.classUri = string2;
        } else if ("classname".equals(string)) {
            this.className = string2;
        } else {
            log.debug("trying to read an undefined parameter '" + string + "' with value '" + string2 + "'. Discarding this");
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TagEntryEntry
    implements Map.Entry<String, String>,
    Comparable<TagEntryEntry> {
        String key;
        String value;

        public TagEntryEntry(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String string) {
            throw new UnsupportedOperationException("do not implement setting values in Tag via the map interface");
        }

        @Override
        public int compareTo(TagEntryEntry tagEntryEntry) {
            int n = tagEntryEntry.key.compareTo(this.key);
            if (n != 0) {
                return n;
            }
            if (this.value == null) {
                if (tagEntryEntry.value == null) {
                    return 0;
                }
                return 1;
            }
            if (tagEntryEntry.value == null) {
                return 1;
            }
            return tagEntryEntry.value.compareTo(this.value);
        }
    }
}

