/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.aperture.websites.iphoto;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.semanticdesktop.aperture.datasource.DataSource;
import org.semanticdesktop.aperture.util.FileUtil;
import org.semanticdesktop.aperture.websites.AbstractTagCrawler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPhotoKeywordCrawler
extends AbstractTagCrawler {
    private static final String BASEURI = "urn:iphoto:keywords:";

    public IPhotoKeywordCrawler() {
    }

    public IPhotoKeywordCrawler(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    @Override
    protected List<String> crawlTags(String string, String string2) throws Exception {
        String string3;
        Method method;
        Object obj;
        Object object;
        try {
            object = this.getClass().getClassLoader().loadClass("org.gnowsis.util.AppleUtils");
            obj = ((Class)object).newInstance();
            method = ((Class)object).getMethod("applescript", String.class);
        }
        catch (Exception exception) {
            throw new Exception("Could not load AppleUtils library.", exception);
        }
        try {
            object = this.getScript();
        }
        catch (IOException iOException) {
            throw new Exception("Could not read applescript resource", iOException);
        }
        try {
            string3 = (String)method.invoke(obj, object);
        }
        catch (Exception exception) {
            throw new Exception("Could not execute applescript!", exception);
        }
        Vector<String> vector = new Vector<String>();
        for (String string4 : Arrays.asList(string3.split("\r"))) {
            vector.add(BASEURI + URLEncoder.encode(string4, "utf-8"));
        }
        return vector;
    }

    private String getScript() throws IOException {
        return FileUtil.readStreamAsUTF8(this.getClass().getResourceAsStream("iphotokeywords.applescript"));
    }
}

