/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.repository.sail.SailRepositoryConnection;
import org.openrdf.rio.RDFFormat;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailException;
import org.semanticdesktop.nepomuk.openrdf.UnionNativeStore;
import org.semanticdesktop.nepomuk.openrdf.UnionSail;

public class SpeedTest {
    public static void testSpeed(RepositoryConnection c, UnionSail unionsail) throws Exception {
        String data = "@prefix foaf: <http://xmlns.com/foaf/0.1/>. \n<urn:dirk> foaf:name \"dirk\" . ";
        String[][] queries = new String[][]{{"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x where { ?x foaf:name \"dirk\" . } ", "whole graph", "2000"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x where { graph <urn:union> { ?x foaf:name \"dirk\" } . } ", "simple unionall", "2000"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x where { graph <urn:unionX> { ?x foaf:name \"dirk\" } . } ", "simple union none", "0"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . } ", "graph var", "2000"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union> ) } ", "graph filter all", "2000"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union1> ) } ", "graph filter half", "1000"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union3> ) } ", "graph filter nested", "2000"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union> || ?g = <urn:unionX> ) } ", "graph filter or none", "2000"}, {"prefix foaf: <http://xmlns.com/foaf/0.1/> \nselect ?x ?g where { graph ?g { ?x foaf:name \"dirk\" } . FILTER (?g = <urn:union1> || ?g = <urn:union2> ) } ", "graph filter both halves", "2000"}};
        Vector<URIImpl> all = new Vector<URIImpl>();
        Vector<URIImpl> half1 = new Vector<URIImpl>();
        Vector<URIImpl> half2 = new Vector<URIImpl>();
        int i = 1;
        while (i <= 1000) {
            if (i % 100 == 0) {
                System.err.print("Setting up... " + i + "   \r");
            }
            StringBuilder sb = new StringBuilder(data);
            int j = 1;
            while (j < i) {
                sb.append("\n<urn:dirk" + j + "> foaf:name \"dirk" + j + "\" .");
                j += 10;
            }
            URIImpl con = new URIImpl("urn:context" + i);
            c.add((Reader)new StringReader(sb.toString()), "http://example.org/", RDFFormat.N3, new Resource[]{con});
            all.add(con);
            if (i <= 1000) {
                half1.add(con);
            } else {
                half2.add(con);
            }
            ++i;
        }
        System.err.println();
        c.commit();
        TupleQuery tq2 = c.prepareTupleQuery(QueryLanguage.SPARQL, queries[0][0]);
        System.err.println("Query 1: " + queries[0][1]);
        long ctm2 = System.currentTimeMillis();
        TupleQueryResult qr2 = tq2.evaluate();
        int res2 = 0;
        while (qr2.hasNext()) {
            String s = ((BindingSet)qr2.next()).toString();
            ++res2;
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - ctm2) + "ms");
        System.err.println(String.valueOf(res2) + " results, " + queries[0][2] + " expected");
        qr2.close();
        URI[] contexts = all.toArray(new URI[all.size()]);
        unionsail.createUnion((URI)new URIImpl("urn:union"), contexts);
        unionsail.createUnion((URI)new URIImpl("urn:union1"), half1.toArray(new URI[half1.size()]));
        unionsail.createUnion((URI)new URIImpl("urn:union2"), half2.toArray(new URI[half2.size()]));
        unionsail.createUnion((URI)new URIImpl("urn:union3"), new URI[]{new URIImpl("urn:union1"), new URIImpl("urn:union2")});
        int iQuery = 0;
        while (iQuery < queries.length) {
            TupleQuery tq = c.prepareTupleQuery(QueryLanguage.SPARQL, queries[iQuery][0]);
            System.err.println("Query " + (iQuery + 1) + ": " + queries[iQuery][1]);
            long ctm = System.currentTimeMillis();
            TupleQueryResult qr = tq.evaluate();
            int res = 0;
            while (qr.hasNext()) {
                String s = ((BindingSet)qr.next()).toString();
                ++res;
            }
            System.err.println("Elapsed: " + (System.currentTimeMillis() - ctm) + "ms");
            System.err.println(String.valueOf(res) + " results, " + queries[iQuery][2] + " expected");
            qr.close();
            ++iQuery;
        }
    }

    public static void main(String[] args) throws Exception {
        File f;
        try {
            f = File.createTempFile("test", "rdf");
        }
        catch (IOException e) {
            throw new SailException((Throwable)e);
        }
        f.delete();
        System.err.println(f);
        UnionNativeStore sail = new UnionNativeStore(f, "spoc, spco, scpo, scop, sopc, socp, ospc, oscp, ocps, ocsp, opsc, opcs, posc, pocs, pcos, pcso, psoc, psco, cosp, cops, cspo, csop, cpso, cpos");
        SailRepository r = new SailRepository((Sail)sail);
        r.initialize();
        SailRepositoryConnection c = r.getConnection();
        c.setAutoCommit(false);
        SpeedTest.testSpeed((RepositoryConnection)c, sail);
        c.close();
        r.shutDown();
    }
}

