/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.iteration.CloseableIteration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailWrapper;
import org.semanticdesktop.nepomuk.openrdf.UnionMaterialisingSailConnection;
import org.semanticdesktop.nepomuk.openrdf.UnionSail;
import org.semanticdesktop.nepomuk.openrdf.UnionSailConnection;
import org.semanticdesktop.nepomuk.openrdf.UnionSailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionMaterialisingSail
extends SailWrapper
implements UnionSail {
    private HashMap<Resource, Set<Resource>> unions;
    private HashMap<Resource, Set<Resource>> invunions;

    public UnionMaterialisingSail(Sail base) {
        super(base);
        this.reset();
    }

    @Override
    public void reset() {
        this.unions = new HashMap();
        this.invunions = new HashMap();
    }

    public SailConnection getConnection() throws SailException {
        return new UnionMaterialisingSailConnection(this, super.getConnection());
    }

    public void initialize() throws SailException {
        super.initialize();
    }

    @Override
    public SailConnection baseGetConnection() throws SailException {
        return this.getBaseSail().getConnection();
    }

    private boolean isEmpty(URI new_context) throws SailException {
        UnionSailConnection c = (UnionSailConnection)this.getConnection();
        try {
            CloseableIteration r = c.getStatements(null, null, null, false, new Resource[]{new_context});
            boolean bl = !r.hasNext();
            return bl;
        }
        finally {
            c.close();
        }
    }

    @Override
    public void createUnion(URI new_context, URI ... contexts) throws SailException {
        SailConnection con = this.baseGetConnection();
        if (!this.isEmpty(new_context)) {
            throw new SailException("Attempting to create new union in non-empty context: " + new_context);
        }
        this.unions.put((Resource)new_context, new HashSet(Arrays.asList(contexts)));
        URI[] uRIArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            URI c = uRIArray[n2];
            if (this.invunions.containsKey(c)) {
                this.invunions.get(c).add((Resource)new_context);
            } else {
                HashSet<URI> set = new HashSet<URI>();
                set.add(new_context);
                this.invunions.put((Resource)c, set);
            }
            ++n2;
        }
        Vector<Statement> statements = new Vector<Statement>();
        URI[] uRIArray2 = contexts;
        int n3 = contexts.length;
        n = 0;
        while (n < n3) {
            URI c = uRIArray2[n];
            CloseableIteration r = con.getStatements(null, null, null, false, new Resource[]{c});
            while (r.hasNext()) {
                statements.add((Statement)r.next());
            }
            r.close();
            ++n;
        }
        for (Statement s : statements) {
            con.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), new Resource[]{new_context});
        }
        con.commit();
        con.close();
    }

    public Set<Resource> getUnionContexts(Resource c) {
        if (this.invunions.containsKey(c)) {
            return this.invunions.get(c);
        }
        return null;
    }

    @Override
    public void addUnion(Resource target, Resource ... contexts) {
        if (this.unions.containsKey(target)) {
            Resource[] resourceArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                Resource c = resourceArray[n2];
                this.unions.get(target).add(c);
                ++n2;
            }
        } else {
            HashSet<Resource> set = new HashSet<Resource>();
            Resource[] resourceArray = contexts;
            int n = contexts.length;
            int n3 = 0;
            while (n3 < n) {
                Resource c = resourceArray[n3];
                set.add(c);
                ++n3;
            }
            this.unions.put(target, set);
        }
    }

    @Override
    public boolean isUnion(Resource context) {
        return this.unions.containsKey(context);
    }

    @Override
    public void debug() {
        System.err.println("Unions:");
        for (Map.Entry<Resource, Set<Resource>> e : this.unions.entrySet()) {
            System.err.println(e.getKey() + " => " + e.getValue());
        }
    }

    @Override
    public boolean isInUnion(Resource context) {
        return this.invunions.containsKey(context);
    }

    @Override
    public void removeUnion(Resource target) throws UnionSailException {
        if (this.isInUnion(target)) {
            throw new UnionSailException("Can not delete union that is in another union. Untangle from top please.");
        }
        if (this.isUnion(target)) {
            for (Resource r : this.unions.get(target)) {
                this.invunions.get(r).remove(target);
            }
            this.unions.remove(target);
            try {
                SailConnection c = this.getConnection();
                c.clear(new Resource[]{target});
                c.commit();
                c.close();
            }
            catch (SailException e) {
                throw new UnionSailException("Could not clear context: ", e);
            }
        } else {
            throw new UnionSailException("Context " + target + " is not a union");
        }
    }
}

