/*
 * Decompiled with CFR 0.152.
 */
package org.semanticdesktop.nepomuk.openrdf;

import info.aduna.iteration.CloseableIteration;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailWrapper;
import org.semanticdesktop.nepomuk.openrdf.UnionRewriteSailConnection;
import org.semanticdesktop.nepomuk.openrdf.UnionSail;
import org.semanticdesktop.nepomuk.openrdf.UnionSailConnection;
import org.semanticdesktop.nepomuk.openrdf.UnionSailException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionRewriteSail
extends SailWrapper
implements UnionSail {
    protected HashMap<Resource, Set<Resource>> unions;

    public UnionRewriteSail(Sail base) {
        super(base);
        this.reset();
    }

    public SailConnection getConnection() throws SailException {
        return new UnionRewriteSailConnection(this, super.getConnection());
    }

    @Override
    public void createUnion(URI new_context, URI ... contexts) throws SailException {
        if (this.unions.containsKey(new_context)) {
            throw new UnionSailException("New union model context is already a union");
        }
        if (!this.isEmpty(new_context)) {
            throw new UnionSailException("New union model context is not empty.");
        }
        this.unions.put((Resource)new_context, this.set((Resource[])contexts));
    }

    private Set<Resource> set(Resource ... contexts) {
        HashSet<Resource> r = new HashSet<Resource>();
        r.addAll((Collection)Arrays.asList(contexts));
        return r;
    }

    private boolean isEmpty(URI new_context) throws SailException {
        UnionSailConnection c = (UnionSailConnection)this.getConnection();
        try {
            CloseableIteration r = c.getStatements(null, null, null, false, new Resource[]{new_context});
            boolean bl = !r.hasNext();
            return bl;
        }
        finally {
            c.close();
        }
    }

    @Override
    public SailConnection baseGetConnection() throws SailException {
        return super.getConnection();
    }

    @Override
    public void reset() {
        this.unions = new HashMap();
    }

    @Override
    public void addUnion(Resource target, Resource ... contexts) {
        if (this.unions.containsKey(target)) {
            Resource[] resourceArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                Resource c = resourceArray[n2];
                this.unions.get(target).add(c);
                ++n2;
            }
        } else {
            HashSet<Resource> set = new HashSet<Resource>();
            Resource[] resourceArray = contexts;
            int n = contexts.length;
            int n3 = 0;
            while (n3 < n) {
                Resource c = resourceArray[n3];
                set.add(c);
                ++n3;
            }
            this.unions.put(target, set);
        }
    }

    @Override
    public boolean isUnion(Resource context) {
        return this.unions.containsKey(context);
    }

    @Override
    public void debug() {
        System.err.println("Unions:");
        for (Map.Entry<Resource, Set<Resource>> e : this.unions.entrySet()) {
            System.err.println(e.getKey() + " => " + e.getValue());
        }
    }

    @Override
    public boolean isInUnion(Resource context) {
        for (Map.Entry<Resource, Set<Resource>> e : this.unions.entrySet()) {
            if (!e.getValue().contains(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeUnion(Resource target) throws UnionSailException {
        if (this.isInUnion(target)) {
            throw new UnionSailException("Can not delete union that is in another union. Untangle from top please.");
        }
        if (!this.isUnion(target)) {
            throw new UnionSailException("Context " + target + " is not a union");
        }
        this.unions.remove(target);
    }
}

