/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.parser;

import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.yars.nx.Node;

public abstract class Callback {
    protected AtomicInteger _openDocuments = new AtomicInteger(0);

    public void startDocument() {
        this.startDocumentInternal();
        this._openDocuments.incrementAndGet();
    }

    public void endDocument() {
        this.endDocumentInternal();
        int i = this._openDocuments.decrementAndGet();
        if (i < 0) {
            throw new IllegalStateException("I don't have a document to end.");
        }
    }

    public void processStatement(Node[] nx) {
        if (this._openDocuments.get() < 1) {
            throw new IllegalStateException("I don't have a document to write to.");
        }
        this.processStatementInternal(nx);
    }

    protected abstract void startDocumentInternal();

    protected abstract void endDocumentInternal();

    protected abstract void processStatementInternal(Node[] var1);
}

