/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.text.Normalizer;
import java.util.ArrayDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NxUtil {
    private static Logger _log = Logger.getLogger(NxUtil.class.getName());
    private static final Pattern IRIPATTERN = Pattern.compile("^([^:/?#]+)://([^/?#]*)?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?");
    private static final Pattern PERCENTPATTERN = Pattern.compile("%[\\dA-Fa-f]{2}");
    private static final Pattern PORTPATTERN = Pattern.compile("(.*):([\\d]*)$");

    private NxUtil() {
    }

    public static String escapeIRI(String iri) {
        StringBuilder result = new StringBuilder();
        block11: for (int i = 0; i < iri.length(); ++i) {
            char c = iri.charAt(i);
            switch (c) {
                case '\\': {
                    result.append("\\u005C");
                    continue block11;
                }
                case '`': {
                    result.append("\\u0060");
                    continue block11;
                }
                case '^': {
                    result.append("\\u005E");
                    continue block11;
                }
                case '|': {
                    result.append("\\u007C");
                    continue block11;
                }
                case '{': {
                    result.append("\\u007B");
                    continue block11;
                }
                case '}': {
                    result.append("\\u007D");
                    continue block11;
                }
                case '\"': {
                    result.append("\\u0022");
                    continue block11;
                }
                case '<': {
                    result.append("\\u003C");
                    continue block11;
                }
                case '>': {
                    result.append("\\u003E");
                    continue block11;
                }
                default: {
                    if (c <= ' ') {
                        result.append(String.format("\\u%04X", c));
                        continue block11;
                    }
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    public static String escapeLiteral(String lit) {
        StringBuilder result = new StringBuilder();
        block6: for (int i = 0; i < lit.length(); ++i) {
            char c = lit.charAt(i);
            switch (c) {
                case '\\': {
                    result.append("\\\\");
                    continue block6;
                }
                case '\"': {
                    result.append("\\\"");
                    continue block6;
                }
                case '\n': {
                    result.append("\\n");
                    continue block6;
                }
                case '\r': {
                    result.append("\\r");
                    continue block6;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    @Deprecated
    public static String escapeForNTriples1(String lit) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lit.length(); ++i) {
            int cp = lit.codePointAt(i);
            if (!Character.isSupplementaryCodePoint(cp)) {
                char c = (char)cp;
                switch (c) {
                    case '\\': {
                        result.append("\\\\");
                        break;
                    }
                    case '\"': {
                        result.append("\\\"");
                        break;
                    }
                    case '\n': {
                        result.append("\\n");
                        break;
                    }
                    case '\r': {
                        result.append("\\r");
                        break;
                    }
                    case '\t': {
                        result.append("\\t");
                        break;
                    }
                    default: {
                        if (c >= '\u0000' && c <= '\b' || c == '\u000b' || c == '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\uffff') {
                            result.append("\\u");
                            result.append(NxUtil.toHexString(c, 4));
                            break;
                        }
                        result.append(c);
                        break;
                    }
                }
                continue;
            }
            result.append("\\U");
            result.append(NxUtil.toHexString(cp, 8));
            ++i;
        }
        return result.toString();
    }

    public static String unescape(String str) {
        int startOfDataToBeUnescaped = str.indexOf("\\");
        if (startOfDataToBeUnescaped == -1) {
            return str;
        }
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        StringBuilder unicode = null;
        boolean hadSlash = false;
        int expectedUnicodeLength = 0;
        buffer.append(str.substring(0, startOfDataToBeUnescaped));
        for (int i = startOfDataToBeUnescaped; i < sz; ++i) {
            char ch = str.charAt(i);
            if (expectedUnicodeLength != 0) {
                unicode.append(ch);
                if (unicode.length() != expectedUnicodeLength) continue;
                expectedUnicodeLength = 0;
                try {
                    buffer.appendCodePoint(Integer.parseInt(unicode.toString(), 16));
                }
                catch (NumberFormatException nfe) {
                    _log.log(Level.WARNING, "Invalid unicode code point in {1}", str);
                    buffer.append(92 + expectedUnicodeLength == 8 ? Character.valueOf('U') : 'u' + unicode.toString());
                }
                continue;
            }
            if (hadSlash) {
                hadSlash = false;
                block1 : switch (ch) {
                    case 'u': {
                        expectedUnicodeLength = 4;
                        unicode = new StringBuilder(4);
                        break;
                    }
                    case 'U': {
                        expectedUnicodeLength = 8;
                        unicode = new StringBuilder(8);
                        break;
                    }
                    default: {
                        switch (ch) {
                            case '\\': {
                                buffer.append('\\');
                                break block1;
                            }
                            case '\'': {
                                buffer.append('\'');
                                break block1;
                            }
                            case '\"': {
                                buffer.append('\"');
                                break block1;
                            }
                            case 'r': {
                                buffer.append('\r');
                                break block1;
                            }
                            case 'f': {
                                buffer.append('\f');
                                break block1;
                            }
                            case 't': {
                                buffer.append('\t');
                                break block1;
                            }
                            case 'n': {
                                buffer.append('\n');
                                break block1;
                            }
                            case 'b': {
                                buffer.append('\b');
                                break block1;
                            }
                        }
                        buffer.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            buffer.append(ch);
        }
        if (hadSlash) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    public static String escapeForMarkup(String lit) {
        String unescaped = NxUtil.unescape(lit);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < unescaped.length(); ++i) {
            int cp = unescaped.codePointAt(i);
            if (!Character.isSupplementaryCodePoint(cp)) {
                char c = (char)cp;
                switch (c) {
                    case '&': {
                        result.append("&amp;");
                        break;
                    }
                    case '<': {
                        result.append("&lt;");
                        break;
                    }
                    case '>': {
                        result.append("&gt;");
                        break;
                    }
                    case '\"': {
                        result.append("&quot;");
                        break;
                    }
                    case '\'': {
                        result.append("&#039;");
                        break;
                    }
                    case '\\': {
                        result.append("&#092;");
                        break;
                    }
                    default: {
                        if (c >= '\u0000' && c <= '\b' || c == '\u000b' || c == '\f' || c >= '\u000e' && c <= '\u001f' || c >= '\u007f' && c <= '\uffff') {
                            result.append("&#x");
                            result.append(NxUtil.toHexString(c, 4));
                            result.append(";");
                            break;
                        }
                        result.append(c);
                        break;
                    }
                }
                continue;
            }
            result.append("&#x");
            result.append(NxUtil.toHexString(cp, 8));
            result.append(";");
            ++i;
        }
        return result.toString();
    }

    private static String toHexString(int decimal, int stringLength) {
        return String.format("%0" + stringLength + "X", decimal);
    }

    public static String unescapeForNTriples1(String str, boolean clean) {
        if (clean) {
            str = NxUtil.cleanSlashes(str);
        }
        return NxUtil.unescape(str);
    }

    private static String cleanSlashes(String str) {
        while (str.indexOf("\\\\") != -1) {
            str = str.replaceAll("\\\\\\\\", "\\\\");
        }
        return str;
    }

    public static String normalize(String iri) {
        if (!Normalizer.isNormalized(iri, Normalizer.Form.NFC)) {
            iri = Normalizer.normalize(iri, Normalizer.Form.NFC);
        }
        String[] iria = NxUtil.splitIRI(iri);
        StringBuilder b = new StringBuilder();
        b.append(iria[0].toLowerCase());
        b.append("://");
        iria[1] = NxUtil.removeStandardPorts(iria[0], iria[1]);
        b.append(NxUtil.unescapePercentEncoding(iria[1], false).toLowerCase());
        iria[2] = NxUtil.removeDotSegments(iria[2]);
        b.append(NxUtil.unescapePercentEncoding(iria[2], false));
        if (iria[3] != "") {
            b.append("?");
        }
        b.append(NxUtil.unescapePercentEncoding(iria[3], true));
        if (iria[4] != "") {
            b.append("#");
        }
        b.append(NxUtil.unescapePercentEncoding(iria[4], false));
        return b.toString();
    }

    public static String[] splitIRI(String iri) {
        Matcher irim = IRIPATTERN.matcher(iri);
        String[] a = new String[5];
        if (irim.find()) {
            for (int i = 1; i <= 5; ++i) {
                String s = irim.group(i);
                a[i - 1] = s == null ? "" : s;
            }
            return a;
        }
        return null;
    }

    public static String getAuthority(String iri) {
        Matcher irim = IRIPATTERN.matcher(iri);
        if (irim.find()) {
            return irim.group(2);
        }
        return null;
    }

    public static String getScheme(String iri) {
        Matcher irim = IRIPATTERN.matcher(iri);
        if (irim.find()) {
            return irim.group(1);
        }
        return null;
    }

    public static String getQuery(String iri) {
        Matcher irim = IRIPATTERN.matcher(iri);
        if (irim.find()) {
            return irim.group(4);
        }
        return null;
    }

    public static String getFragment(String iri) {
        Matcher irim = IRIPATTERN.matcher(iri);
        if (irim.find()) {
            return irim.group(5);
        }
        return null;
    }

    public static String getPath(String iri) {
        Matcher irim = IRIPATTERN.matcher(iri);
        if (irim.find()) {
            return irim.group(3);
        }
        return null;
    }

    public static String unescapePercentEncoding(String str, Boolean privateUCS) {
        StringBuilder result = new StringBuilder(str.length());
        StringBuilder orig = new StringBuilder();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '%' && i + 2 < str.length()) {
                String enc = str.substring(i + 1, i + 3);
                orig.append('%');
                orig.append(enc);
                int value = Integer.parseInt(enc, 16);
                if ((value & 0x80) == 0) {
                    bytes.write((byte)value);
                } else if ((value & 0x20) == 0 && i + 5 < str.length() && str.charAt(i + 3) == '%') {
                    bytes.write((byte)value);
                    enc = str.substring((i += 3) + 1, i + 3);
                    orig.append('%');
                    orig.append(enc);
                    bytes.write(Integer.parseInt(enc, 16));
                } else if ((value & 0x10) == 0 && i + 8 < str.length() && str.charAt(i + 3) == '%' && str.charAt(i + 6) == '%') {
                    bytes.write((byte)value);
                    for (int j = 0; j < 2; ++j) {
                        enc = str.substring((i += 3) + 1, i + 3);
                        orig.append('%');
                        orig.append(enc);
                        bytes.write(Integer.parseInt(enc, 16));
                    }
                } else if ((value & 8) == 0 && i + 11 < str.length() && str.charAt(i + 3) == '%' && str.charAt(i + 6) == '%' && str.charAt(i + 9) == '%') {
                    bytes.write((byte)value);
                    for (int j = 0; j < 3; ++j) {
                        enc = str.substring((i += 3) + 1, i + 3);
                        orig.append('%');
                        orig.append(enc);
                        bytes.write(Integer.parseInt(enc, 16));
                    }
                } else {
                    result.append(orig.toString());
                    orig.setLength(0);
                    orig.trimToSize();
                    i += 3;
                    continue;
                }
                String s = null;
                try {
                    s = new String(bytes.toByteArray(), "utf-8");
                }
                catch (UnsupportedEncodingException e1) {
                    e1.printStackTrace();
                }
                assert (s.codePointCount(0, s.length()) == 1);
                try {
                    ByteBuffer b = ByteBuffer.wrap(s.getBytes("UTF-32BE"));
                    value = b.getInt();
                    if (value >= 65 && value <= 90 || value >= 97 && value <= 122 || value >= 48 && value <= 57 || value == 45 || value == 46 || value == 95 || value == 126 || value >= 160 && value <= 55295 || value >= 63744 && value <= 64975 || value >= 65008 && value <= 65279 || value >= 65536 && value <= 131069 || value >= 131072 && value <= 196605 || value >= 196608 && value <= 262141 || value >= 262144 && value <= 327677 || value >= 327680 && value <= 393213 || value >= 393216 && value <= 458749 || value >= 458752 && value <= 524285 || value >= 524288 && value <= 589821 || value >= 589824 && value <= 655357 || value >= 655360 && value <= 720893 || value >= 720896 && value <= 786429 || value >= 786432 && value <= 851965 || value >= 851968 && value <= 917501 || value >= 921600 && value <= 983037) {
                        result.append(Character.toChars(value));
                    } else if (privateUCS.booleanValue()) {
                        if (value >= 57344 && value <= 63743 || value >= 983040 && value <= 1048573 || value >= 0x100000 && value <= 1114109) {
                            result.append(Character.toChars(value));
                        } else {
                            result.append(orig.toString().toUpperCase());
                        }
                    } else {
                        result.append(orig.toString().toUpperCase());
                    }
                }
                catch (NumberFormatException e) {
                    result.append(orig.toString().toUpperCase());
                }
                catch (UnsupportedEncodingException e) {
                    result.append(orig.toString().toUpperCase());
                }
                orig.setLength(0);
                orig.trimToSize();
                bytes.reset();
                i += 3;
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static String caseNormalizePercentEncoding(String str) {
        StringBuilder buffer = new StringBuilder();
        Matcher m = PERCENTPATTERN.matcher(str);
        int last = 0;
        while (m.find()) {
            buffer.append(str.substring(last, m.start()));
            String enc = m.group();
            last = m.end();
            buffer.append(enc.toUpperCase());
        }
        buffer.append(str.substring(last));
        return buffer.toString();
    }

    public static String removeStandardPorts(String scheme, String authority) {
        Matcher m = PORTPATTERN.matcher(authority);
        if (m.find()) {
            if (m.group(2).equals("")) {
                return m.group(1);
            }
            int port = Integer.parseInt(m.group(2));
            if ((scheme = scheme.toLowerCase()).equals("http") && port == 80) {
                return m.group(1);
            }
            if (scheme.equals("https") && port == 443) {
                return m.group(1);
            }
        }
        return authority;
    }

    public static String removeDotSegments(String path) {
        StringBuilder output = new StringBuilder(path.length());
        ArrayDeque<String> in = new ArrayDeque<String>();
        ArrayDeque<String> out = new ArrayDeque<String>();
        int start = 0;
        int end = 1;
        while (end < path.length()) {
            if (path.charAt(end) == '/') {
                in.addLast(path.substring(start, end));
                start = end++;
                continue;
            }
            ++end;
        }
        if (!(path.equals("") || path.charAt(path.length() - 1) == '/' && path.length() != 1)) {
            in.addLast(path.substring(start));
        }
        while (!in.isEmpty()) {
            String segment = (String)in.removeFirst();
            if (segment.equals("../") || segment.equals("./")) continue;
            if (segment.equals("/./") || segment.equals("/.")) {
                if (!in.isEmpty()) continue;
                out.addLast("/");
                continue;
            }
            if (segment.equals("/../") || segment.equals("/..")) {
                while (!out.isEmpty() && ((String)out.removeLast()).equals("")) {
                }
                if (!in.isEmpty()) continue;
                out.addLast("/");
                continue;
            }
            if (segment.equals("..") || segment.equals(".")) continue;
            if (segment.charAt(segment.length() - 1) != '/' || segment.length() == 1) {
                out.addLast(segment);
                continue;
            }
            out.addLast(segment.substring(0, segment.length() - 1));
        }
        for (String s : out) {
            output.append(s);
        }
        if (output.length() == 0) {
            output.append('/');
        }
        return output.toString();
    }
}

