/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.parser.ParseException;

public class BNode
implements Node {
    private static Logger _log = Logger.getLogger(BNode.class.getName());
    static final String PREFIX = "_:";
    private final String _data;
    private static final long serialVersionUID = 1L;

    public BNode(String nodeid) {
        this(nodeid, false);
    }

    public BNode(String nodeid, boolean isNTriples) {
        this._data = isNTriples ? nodeid : (!nodeid.startsWith(PREFIX) ? PREFIX + nodeid : nodeid);
    }

    @Deprecated
    public String getBNodeString() {
        return this._data.substring(PREFIX.length());
    }

    @Override
    public String getLabel() {
        return this.getBNodeString();
    }

    @Override
    public String toString() {
        return this._data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof BNode && ((BNode)o)._data.equals(this._data);
    }

    @Override
    public int hashCode() {
        return this._data.hashCode();
    }

    @Override
    public int compareTo(Node n) {
        return this.toString().compareTo(n.toString());
    }

    public String[] parseContextualBNode() throws ParseException {
        String d = this._data.substring(PREFIX.length());
        String[] uri = d.toString().split("xx");
        if (uri.length != 2) {
            throw new ParseException("Not a valid context encoded BNode " + this._data);
        }
        uri[0] = BNode.unescapeForBNode(uri[0]);
        uri[1] = BNode.unescapeForBNode(uri[1]);
        return uri;
    }

    public static String[] parseContextualBNode(BNode b) throws ParseException {
        String[] uri = b.toString().split("xx");
        if (uri.length != 2) {
            throw new ParseException("Not a valid context encoded BNode " + b);
        }
        uri[0] = BNode.unescapeForBNode(uri[0]);
        uri[1] = BNode.unescapeForBNode(uri[1]);
        return uri;
    }

    public static BNode createBNode(String docURI, String localID) {
        String escapedDU = BNode.escapeForBNode(docURI);
        String escapedLI = BNode.escapeForBNode(localID);
        return new BNode(escapedLI + "xx" + escapedDU);
    }

    public static BNode createBNode(String unescaped) {
        String escaped = BNode.escapeForBNode(unescaped);
        return new BNode(escaped);
    }

    public static String escapeForBNode(String unescaped) {
        try {
            return URLEncoder.encode(unescaped, "utf-8").replace("x", "x78").replace("-", "x2D").replace(".", "x2E").replace("_", "x5F").replace("*", "x2A").replace('%', 'x');
        }
        catch (UnsupportedEncodingException e) {
            _log.log(Level.WARNING, "Exception: {}", e.getMessage());
            return null;
        }
    }

    public static String unescapeForBNode(String escaped) {
        try {
            return URLDecoder.decode(escaped.replace('x', '%'), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            _log.log(Level.WARNING, "Exception: {}", e.getMessage());
            return null;
        }
    }
}

