/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.util.NxUtil;

public class Literal
implements Node {
    private static Logger _log = Logger.getLogger(Literal.class.getName());
    private final String _data;
    private static final long serialVersionUID = 2L;

    public Literal(String data) {
        this(data, null, null, false);
    }

    public Literal(String data, boolean isNTriples) {
        this(data, null, null, isNTriples);
    }

    public Literal(String data, String lang) {
        this(data, lang, null, false);
    }

    public Literal(String data, Resource dt) {
        this(data, null, dt, false);
    }

    public Literal(String data, String lang, Resource dt) {
        this(data, lang, dt, false);
    }

    private Literal(String data, String lang, Resource dt, boolean isNTriples) {
        if (isNTriples) {
            this._data = data;
        } else {
            if (data.equals("") || data.charAt(0) != '\"' || data.charAt(data.length() - 1) != '\"' || data.charAt(data.length() - 1) == '\"' && data.charAt(data.length() - 2) == '\n') {
                _log.log(Level.FINE, "Escaping and adding quotes for Literal {}", data);
                data = NxUtil.escapeLiteral((String)data);
                data = '\"' + data + '\"';
            } else {
                _log.log(Level.FINE, "Assuming spec conformity for Literal {}", data);
            }
            if (lang != null && dt != null) {
                throw new IllegalArgumentException("Specify only one of language and datatype.");
            }
            this._data = data + (lang == null ? (dt == null ? "" : "^^" + dt) : "@" + lang);
        }
    }

    @Override
    public String getLabel() {
        int i = this._data.lastIndexOf("\"");
        return NxUtil.unescape((String)this._data.substring(1, i));
    }

    public String getLanguageTag() {
        int i = this._data.lastIndexOf("\"");
        String str = this._data.substring(i + 1);
        if (!str.startsWith("@")) {
            return null;
        }
        return str.substring(1);
    }

    public Resource getDatatype() {
        int i = this._data.lastIndexOf("\"");
        String str = this._data.substring(i + 1);
        if (!str.startsWith("^^<") || !str.endsWith(">")) {
            return null;
        }
        return new Resource(str.substring(2), true);
    }

    @Override
    public String toString() {
        return this._data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Literal && ((Literal)o)._data.equals(this._data);
    }

    @Override
    public int hashCode() {
        return this._data.hashCode();
    }

    @Override
    public int compareTo(Node n) {
        return this.toString().compareTo(n.toString());
    }
}

