/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.util.NxUtil;

public class Resource
implements Node,
Serializable {
    private static Logger _log = Logger.getLogger(Resource.class.getName());
    protected String _data;
    public static final long serialVersionUID = 2L;

    public Resource(String iri) {
        this(iri, false);
    }

    public Resource(String iri, boolean isNTriples) {
        if (!isNTriples) {
            if (iri == null || iri.length() == 0) {
                _log.log(Level.WARNING, "Empty string not allowed.");
                this._data = "<>";
            } else if (iri.charAt(0) != '<') {
                this._data = "<" + NxUtil.escapeIRI((String)iri) + ">";
            } else {
                _log.log(Level.WARNING, "Bare and valid IRI expected, was supplied something with brackets <>: {0}", iri);
                this._data = NxUtil.escapeIRI((String)iri);
            }
        } else {
            this._data = iri;
        }
    }

    public URI toURI() throws URISyntaxException {
        return new URI(this.getUriString());
    }

    @Deprecated
    public String getUriString() {
        return NxUtil.unescape((String)this.toString().substring(1, this.toString().length() - 1));
    }

    @Override
    public String getLabel() {
        return this.getUriString();
    }

    @Override
    public String toString() {
        return this._data;
    }

    @Override
    public int hashCode() {
        return this._data.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof Resource && ((Resource)o)._data.equals(this._data);
    }

    @Override
    public int compareTo(Node n) {
        return this.toString().compareTo(n.toString());
    }
}

