/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;

public class ExceptionCollectingNxParser
implements Iterator<Node[]>,
Iterable<Node[]> {
    Queue<Exception> _exceptions = new LinkedList<Exception>();
    BufferedReader _br;
    boolean _nextIsFresh = false;
    Node[] _next = null;

    public void parse(InputStream is, Charset cs) {
        this.parse(new BufferedReader(new InputStreamReader(is, cs)));
    }

    public void parse(BufferedReader br) {
        this._br = br;
        this._next = null;
        this._nextIsFresh = false;
        this._exceptions.clear();
    }

    @Override
    public Iterator<Node[]> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this._nextIsFresh && this._next != null) {
            return true;
        }
        if (!this._nextIsFresh) {
            if (this._br == null) {
                return false;
            }
            this.loadNext();
            return this._next != null;
        }
        return false;
    }

    private void loadNext() {
        this._next = null;
        if (this._br == null) {
            return;
        }
        String line = null;
        try {
            line = this._br.readLine();
            if (line != null) {
                do {
                    try {
                        this._next = NxParser.parseNodes(line);
                    }
                    catch (ParseException e) {
                        this._exceptions.add((Exception)((Object)e));
                        this._next = null;
                    }
                } while (this._next == null && (line = this._br.readLine()) != null);
            }
        }
        catch (IOException e1) {
            this._exceptions.add(e1);
        }
        this._nextIsFresh = true;
    }

    @Override
    public Node[] next() {
        if (this._nextIsFresh) {
            this._nextIsFresh = false;
            return this._next;
        }
        if (this.hasNext()) {
            return this._next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Queue<Exception> getExceptions() {
        return this._exceptions;
    }
}

