/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.rdfxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.rdfxml.CallbackBlockingQueue;
import org.semanticweb.yars.rdfxml.ParserThread;
import org.semanticweb.yars.rdfxml.RdfXmlParserBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RdfXmlParser
implements Iterator<Node[]>,
Iterable<Node[]> {
    private BlockingQueue<Node[]> _q = null;
    private boolean _done = false;
    private Exception _e = null;
    private ParserThread _pt = null;
    private Node[] _current = null;
    private Resource _con = null;
    public static final int DEFAULT_BUFFER = 1000;
    public static final int TIME_OUT = 1000;
    private SAXParser _parser;

    public RdfXmlParser() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        try {
            this._parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public Iterator<Node[]> parse(InputStream in, String baseURI) throws ParseException, IOException {
        return this.parse(in, false, true, baseURI, 1000);
    }

    public Iterator<Node[]> parse(InputStream in, boolean strict, boolean skolemise, String baseURI) throws ParseException, IOException {
        return this.parse(in, strict, skolemise, baseURI, 1000);
    }

    public Iterator<Node[]> parse(InputStream in, boolean strict, boolean skolemise, String baseURI, int buffer) throws ParseException, IOException {
        try {
            this._q = new ArrayBlockingQueue<Node[]>(buffer);
            CallbackBlockingQueue bcb = new CallbackBlockingQueue(this._q);
            this._pt = new ParserThread(this._parser, in, new RdfXmlParserBase(baseURI, bcb, skolemise), this._q);
            this._pt.start();
        }
        catch (Exception err) {
            throw new ParseException(err);
        }
        return this;
    }

    @Deprecated
    public void parse(InputStream in, boolean strict, boolean skolemise, String baseURI, Callback c) throws ParseException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(strict);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)new RdfXmlParserBase(baseURI, c, skolemise));
        }
        catch (Exception err) {
            throw new ParseException(err);
        }
    }

    public void parse(InputStream in, boolean strict, boolean skolemise, String baseURI, Callback c, Resource con) throws ParseException, IOException {
        this._con = con;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(strict);
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(in, (DefaultHandler)new RdfXmlParserBase(baseURI, c, skolemise, con));
        }
        catch (Exception err) {
            throw new ParseException(err);
        }
    }

    public Resource getContext() {
        return this._con;
    }

    @Override
    public boolean hasNext() {
        if (this._q == null) {
            return false;
        }
        if (this._done) {
            return false;
        }
        if (this._current != null) {
            if (this._current.length == 0) {
                this._done = true;
                this._e = this._pt.getException();
                return false;
            }
            return true;
        }
        if (this._q.size() > 0) {
            this._current = (Node[])this._q.poll();
            return this.hasNext();
        }
        try {
            this._current = this._q.poll(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this._done = true;
            return false;
        }
        return this.hasNext();
    }

    @Override
    public Node[] next() {
        if (this._current == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        Node[] result = new Node[this._current.length];
        System.arraycopy(this._current, 0, result, 0, this._current.length);
        this._current = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean isSuccess() {
        return this._e == null;
    }

    public Exception getException() {
        return this._e;
    }

    @Override
    public Iterator<Node[]> iterator() {
        return this;
    }
}

