/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.jena.core.sink;

import com.hp.hpl.jena.datatypes.BaseDatatype;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Model;
import java.util.HashMap;
import java.util.Map;
import org.semarglproject.sink.TripleSink;

public abstract class AbstractJenaSink
implements TripleSink {
    public static final String OUTPUT_MODEL_PROPERTY = "http://semarglproject.org/jena/properties/output-model";
    protected Model model;
    private final Map<String, Node> bnodeMap;

    protected AbstractJenaSink(Model model) {
        this.model = model;
        this.bnodeMap = new HashMap<String, Node>();
    }

    private Node getBNode(String bnode) {
        if (!this.bnodeMap.containsKey(bnode)) {
            this.bnodeMap.put(bnode, Node.createAnon());
        }
        return this.bnodeMap.get(bnode);
    }

    private Node convertNonLiteral(String arg) {
        if (arg.startsWith("_:")) {
            return this.getBNode(arg);
        }
        return Node.createURI((String)arg);
    }

    public final void addNonLiteral(String subj, String pred, String obj) {
        this.addTriple(this.convertNonLiteral(subj), Node.createURI((String)pred), this.convertNonLiteral(obj));
    }

    public final void addPlainLiteral(String subj, String pred, String content, String lang) {
        if (lang == null) {
            this.addTriple(this.convertNonLiteral(subj), Node.createURI((String)pred), Node.createLiteral((String)content));
        } else {
            this.addTriple(this.convertNonLiteral(subj), Node.createURI((String)pred), Node.createLiteral((String)content, (String)lang, (boolean)false));
        }
    }

    public final void addTypedLiteral(String subj, String pred, String content, String type) {
        Node literal = Node.createLiteral((String)content, (String)"", (RDFDatatype)new BaseDatatype(type));
        this.addTriple(this.convertNonLiteral(subj), Node.createURI((String)pred), literal);
    }

    public boolean setProperty(String key, Object value) {
        if (OUTPUT_MODEL_PROPERTY.equals(key) && value instanceof Model) {
            this.model = (Model)value;
            return true;
        }
        return false;
    }

    protected abstract void addTriple(Node var1, Node var2, Node var3);
}

