/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.jena.core.sink;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import org.semarglproject.jena.core.sink.AbstractJenaSink;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.TripleSink;

public final class JenaSink
extends AbstractJenaSink {
    private static final int DEFAULT_BATCH_SIZE = 512;
    private final int batchSize;
    private Triple[] triples;
    private int triplesSize;

    private JenaSink(Model model, int batchSize) {
        super(model);
        this.batchSize = batchSize;
    }

    public static TripleSink connect(Model model) {
        return new JenaSink(model, 512);
    }

    private void newBatch() {
        this.triples = new Triple[this.batchSize];
        this.triplesSize = 0;
    }

    @Override
    protected void addTriple(Node subj, Node pred, Node obj) {
        this.triples[this.triplesSize++] = new Triple(subj, pred, obj);
        if (this.triplesSize == this.batchSize) {
            this.model.enterCriticalSection(false);
            this.model.getGraph().getBulkUpdateHandler().add(this.triples);
            this.model.leaveCriticalSection();
            this.newBatch();
        }
    }

    public void startStream() throws ParseException {
        this.newBatch();
    }

    public void endStream() throws ParseException {
        if (this.triplesSize == 0) {
            return;
        }
        Triple[] dummy = new Triple[this.triplesSize];
        System.arraycopy(this.triples, 0, dummy, 0, this.triplesSize);
        this.model.enterCriticalSection(false);
        this.model.getGraph().getBulkUpdateHandler().add(dummy);
        this.model.leaveCriticalSection();
    }

    public void setBaseUri(String baseUri) {
    }
}

