/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.jena.rdf.rdfa;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.impl.RDFReaderFImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.semarglproject.jena.core.sink.JenaSink;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.rdfa.RdfaParser;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.source.StreamProcessor;

public final class JenaRdfaReader
implements RDFReader {
    private final StreamProcessor streamProcessor = new StreamProcessor((DataSink)RdfaParser.connect((TripleSink)JenaSink.connect(null)));

    public static void inject() {
        RDFReaderFImpl.setBaseReaderClassName((String)"RDFA", (String)JenaRdfaReader.class.getName());
    }

    public void read(Model model, Reader r, String base) {
        this.streamProcessor.setProperty("http://semarglproject.org/jena/properties/output-model", (Object)model);
        try {
            this.streamProcessor.process(r, base);
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Model model, InputStream r, String base) {
        boolean txSupported = model.supportsTransactions();
        InputStreamReader reader = new InputStreamReader(r);
        try {
            if (txSupported) {
                model.begin();
            }
            this.read(model, reader, base);
        }
        finally {
            if (txSupported) {
                model.abort();
            }
            try {
                reader.close();
            }
            catch (IOException e) {}
        }
        if (txSupported) {
            model.commit();
        }
    }

    public void read(Model model, String url) {
        try {
            URL uri = new URL(url);
            this.read(model, uri.openStream(), url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object setProperty(String propName, Object propValue) {
        return this.streamProcessor.setProperty(propName, propValue);
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler errHandler) {
        return null;
    }
}

