/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.CharSink;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.Pipe;
import org.semarglproject.sink.TripleSink;

public final class TurtleSerializer
extends Pipe<CharSink>
implements TripleSink {
    private static final String DOT_EOL = " .\n";
    private static final String COMMA_EOL = " ,\n";
    private static final String SEMICOLON_EOL = " ;\n";
    private static final String EOL = "\n";
    private static final String MULTILINE_QUOTE = "\"\"\"";
    private static final char SINGLE_LINE_QUOTE = '\"';
    private static final char BNODE_START = '[';
    private static final char BNODE_END = ']';
    private static final char URI_START = '<';
    private static final char URI_END = '>';
    private static final char SPACE = ' ';
    private static final char RDF_TYPE_ABBR = 'a';
    private static final String INDENT = "    ";
    private static final short BATCH_SIZE = 10;
    private StringBuilder builder;
    private String prevSubj;
    private String prevPred;
    private short step;
    private final Queue<String> bnodeStack = new LinkedList<String>();
    private final Set<String> namedBnodes = new HashSet<String>();
    private String baseUri;

    private TurtleSerializer(CharSink sink) {
        super((DataSink)sink);
    }

    public static TripleSink connect(CharSink sink) {
        return new TurtleSerializer(sink);
    }

    public void addNonLiteral(String subj, String pred, String obj) {
        this.startTriple(subj, pred);
        if (obj.startsWith("_:")) {
            if (!this.namedBnodes.contains(obj) && obj.endsWith("sbl")) {
                this.openBnode(obj);
            } else {
                this.builder.append(obj);
            }
        } else {
            this.serializeUri(obj);
        }
        this.endTriple();
    }

    public void addPlainLiteral(String subj, String pred, String content, String lang) {
        this.startTriple(subj, pred);
        this.addContent(content);
        if (lang != null) {
            this.builder.append('@').append(lang);
        }
        this.endTriple();
    }

    public void addTypedLiteral(String subj, String pred, String content, String type) {
        this.startTriple(subj, pred);
        this.addContent(content);
        this.builder.append("^^");
        this.serializeUri(type);
        this.endTriple();
    }

    public void startStream() throws ParseException {
        this.prevSubj = null;
        this.prevPred = null;
        this.builder = new StringBuilder();
        if (this.baseUri != null) {
            this.builder.append("@base ").append('<').append(this.baseUri).append('>').append(DOT_EOL);
        }
        this.builder.append("@prefix rdf: ").append('<').append("http://www.w3.org/1999/02/22-rdf-syntax-ns#").append('>').append(DOT_EOL);
        this.step = 0;
        this.bnodeStack.clear();
        this.namedBnodes.clear();
        super.startStream();
    }

    public void endStream() throws ParseException {
        super.endStream();
        if (this.builder == null) {
            this.builder = new StringBuilder();
        }
        while (!this.bnodeStack.isEmpty()) {
            this.closeBnode();
        }
        if (this.prevPred != null) {
            this.builder.append(DOT_EOL);
        } else {
            this.builder.append(EOL);
        }
        if (this.builder != null) {
            ((CharSink)this.sink).process(this.builder.toString());
        }
        this.builder = null;
        this.baseUri = null;
    }

    protected boolean setPropertyInternal(String key, Object value) {
        return false;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri.substring(0, baseUri.length() - 1);
    }

    private void startTriple(String subj, String pred) {
        if (this.builder == null) {
            this.builder = new StringBuilder();
        }
        if (subj.equals(this.prevSubj)) {
            if (pred.equals(this.prevPred)) {
                this.builder.append(COMMA_EOL);
                this.indent(2);
            } else if (this.prevPred != null) {
                this.builder.append(SEMICOLON_EOL);
                this.indent(1);
                this.serializePredicate(pred);
            } else {
                this.indent(0);
                this.serializePredicate(pred);
            }
        } else {
            if (!this.bnodeStack.isEmpty()) {
                this.closeBnode();
                this.startTriple(subj, pred);
                return;
            }
            if (this.prevSubj != null) {
                this.builder.append(DOT_EOL);
            }
            if (subj.startsWith("_:")) {
                if (subj.endsWith("sbl")) {
                    this.openBnode(subj);
                } else {
                    this.builder.append(subj).append(' ');
                    this.namedBnodes.add(subj);
                }
            } else {
                this.serializeUri(subj);
            }
            this.serializePredicate(pred);
        }
        this.prevSubj = subj;
        this.prevPred = pred;
    }

    private void serializePredicate(String pred) {
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(pred)) {
            this.builder.append('a').append(' ');
        } else {
            this.serializeUri(pred);
        }
    }

    private void serializeUri(String uri) {
        String escapedUri = uri.replace("\\", "\\\\").replace(">", "\\u003E");
        if (escapedUri.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            this.builder.append("rdf:").append(escapedUri.substring("http://www.w3.org/1999/02/22-rdf-syntax-ns#".length()));
        } else if (this.baseUri != null && escapedUri.startsWith(this.baseUri)) {
            this.builder.append('<').append(escapedUri.substring(this.baseUri.length())).append('>');
        } else {
            this.builder.append('<').append(escapedUri).append('>');
        }
        this.builder.append(' ');
    }

    private void indent(int additionalIndent) {
        for (int i = 0; i < this.bnodeStack.size() + additionalIndent; ++i) {
            this.builder.append(INDENT);
        }
    }

    private void endTriple() {
        if (this.step == 10) {
            try {
                ((CharSink)this.sink).process(this.builder.toString());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.builder = null;
            this.step = 0;
        }
        this.step = (short)(this.step + 1);
    }

    private void addContent(String content) {
        String escapedContent = content.replace("\\", "\\\\").replace("\"", "\\\"");
        if (escapedContent.contains(EOL)) {
            this.builder.append(MULTILINE_QUOTE).append(escapedContent).append(MULTILINE_QUOTE);
        } else {
            this.builder.append('\"').append(escapedContent).append('\"');
        }
    }

    private void openBnode(String obj) {
        this.builder.append('[');
        this.bnodeStack.offer(obj);
        this.prevSubj = obj;
        this.prevPred = null;
    }

    private void closeBnode() {
        this.builder.append(']');
        this.bnodeStack.poll();
        this.prevSubj = this.bnodeStack.peek();
        this.prevPred = null;
        if (this.prevSubj == null) {
            this.builder.append(DOT_EOL);
        }
    }
}

