import { ComponentProps, useState } from 'react';
import { Story } from '@storybook/react';

import { Accordion } from './';
import { Input } from '../Input';

export default {
    title: 'Components/Accordion',
    component: Accordion,
    subcomponents: {
        Content: Accordion.Content,
        Item: Accordion.Item,
        Trigger: Accordion.Trigger,
    },
};

/* Stories */

const Template: Story<ComponentProps<typeof Accordion>> = ({ ...args }) => {
    const [selectedValue, setSelectedValue] = useState('');

    return (
        <Accordion
            {...args}
            multiple={false}
            onChange={setSelectedValue}
            value={selectedValue}
        >
            <Accordion.Item value="text">
                <Accordion.Trigger>Accordion Trigger</Accordion.Trigger>
                <Accordion.Content>Accordion Content</Accordion.Content>
            </Accordion.Item>
            <Accordion.Item value="input">
                <Accordion.Trigger>input</Accordion.Trigger>
                <Accordion.Content>
                    <Input />
                </Accordion.Content>
            </Accordion.Item>
            <Accordion.Item value="disabled" disabled={true}>
                <Accordion.Trigger>disabled</Accordion.Trigger>
                <Accordion.Content>placeholder content</Accordion.Content>
            </Accordion.Item>
        </Accordion>
    );
};

export const Default = Template.bind({});

Default.args = {
    name: 'demo',
};
