import { ComponentProps } from 'react';
import { Story, Meta } from '@storybook/react';
import { Alert } from './Alert';

export default {
    title: 'Components/Alert',
    component: Alert,
    argTypes: {
        variant: {
            control: {
                type: 'select',
                required: false,
            },
            table: {
                defaultValue: {
                    summary: 'filled',
                },
            },
        },
        color: {
            control: {
                type: 'select',
                required: false,
            },
            table: {
                defaultValue: {
                    summary: 'primary',
                },
            },
        },
        action: {
            control: {
                type: 'text',
                required: false,
            },
            table: {
                defaultValue: {
                    summary: '',
                },
            },
        },
    },
} as Meta;

/* Stories */
const Template: Story<ComponentProps<typeof Alert>> = (args) => (
    <Alert {...args} />
);

const MultiTemplate: Story<ComponentProps<typeof Alert>> = (args) => (
    <>
        <Alert variant="filled" {...args} />
        <br />
        <Alert variant="outline" {...args} />
        <br />
        <Alert variant="notification" {...args} />
    </>
);

// Default
export const Default = Template.bind({});

Default.args = {
    children: 'Alert',
};

// Primary
export const Primary = MultiTemplate.bind({});

Primary.args = {
    ...Default.args,
    color: 'primary',
};

Primary.argTypes = {
    variant: {
        control: false,
    },
};

// Success
export const Success = MultiTemplate.bind({});

Success.args = {
    ...Default.args,
    color: 'success',
};

Success.argTypes = {
    variant: {
        control: false,
    },
};

// Warning
export const Warning = MultiTemplate.bind({});

Warning.args = {
    ...Default.args,
    color: 'warning',
};

Warning.argTypes = {
    variant: {
        control: false,
    },
};

// Alert
export const Error = MultiTemplate.bind({});

Error.args = {
    ...Default.args,
    color: 'error',
};

Error.argTypes = {
    variant: {
        control: false,
    },
};
