import React, { forwardRef } from 'react';
import { theme, styled } from '../../stitches.config';

const StyledBreadcrumbItem = styled('a', {
    flex: 'none',
    flexGrow: '0',
    fontSize: theme.fontSizes.sm,
    color: theme.colors['grey-1'],
    textDecoration: 'none',
    cursor: 'pointer',
    variants: {
        last: {
            true: {
                fontWeight: theme.fontWeights['semibold'],
            },
            false: {
                '&:hover': {
                    color: theme.colors['primary-1'],
                },
            },
        },
    },
});

export interface BreadcrumbItemProps extends React.ComponentPropsWithRef<'a'> {
    /* Link to navigate to */
    href: HTMLAnchorElement['href'];
}

/**
 * Breadcrumb Item component -- each individual link
 * **/
export const BreadcrumbItem = forwardRef<
    HTMLAnchorElement,
    BreadcrumbItemProps
>((props, ref): JSX.Element => {
    const {
        children,
        href, // @ts-expect-error: Passed in from Parent Breadcrumb
        last,
        ...otherProps
    } = props;

    return (
        <li>
            <StyledBreadcrumbItem
                ref={ref}
                href={href}
                last={last}
                {...otherProps}
            >
                {children}
            </StyledBreadcrumbItem>
        </li>
    );
});

BreadcrumbItem.displayName = 'BreadcrumbItem';
