import { ComponentProps } from 'react';
import { Story, Meta } from '@storybook/react';
import { Button } from './Button';
import { Icon } from '../Icon';

const mdiInformation =
    'M13,9H11V7H13M13,17H11V11H13M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z';

export default {
    title: 'Components/Button',
    component: Button,
    argTypes: {
        variant: {
            control: {
                type: 'select',
                required: false,
            },
            table: {
                defaultValue: {
                    summary: 'filled',
                },
            },
        },
        color: {
            control: {
                type: 'select',
                required: false,
            },
            table: {
                defaultValue: {
                    summary: 'primary',
                },
            },
        },
        size: {
            control: {
                type: 'select',
                required: false,
            },
            table: {
                defaultValue: {
                    summary: 'md',
                },
            },
        },
    },
} as Meta;

/* Stories */
const Template: Story<ComponentProps<typeof Button>> = (args) => (
    <Button {...args} />
);

const MultiVariantTemplate: Story<ComponentProps<typeof Button>> = (args) => (
    <>
        <div style={{ display: 'flex', gap: '0.5rem', marginBottom: '0.5rem' }}>
            <Button variant="filled" size="sm" {...args} />
            <Button variant="outline" size="sm" {...args} />
            <Button variant="text" size="sm" {...args} />
        </div>
        <div style={{ display: 'flex', gap: '0.5rem', marginBottom: '0.5rem' }}>
            <Button variant="filled" size="md" {...args} />
            <Button variant="outline" size="md" {...args} />
            <Button variant="text" size="md" {...args} />
        </div>
        <div style={{ display: 'flex', gap: '0.5rem' }}>
            <Button variant="filled" size="lg" {...args} />
            <Button variant="outline" size="lg" {...args} />
            <Button variant="text" size="lg" {...args} />
        </div>
    </>
);

const MultiSizeTemplate: Story<ComponentProps<typeof Button>> = (args) => (
    <>
        <div style={{ display: 'flex', gap: '0.5rem' }}>
            <Button size="sm" {...args} />
            <Button size="md" {...args} />
            <Button size="lg" {...args} />
        </div>
    </>
);

const IconTemplate: Story<ComponentProps<typeof Button>> = (args) => (
    <>
        <div style={{ display: 'flex', gap: '0.5rem' }}>
            <Button {...args} prepend={<Icon path={mdiInformation} />} />
            <Button {...args} append={<Icon path={mdiInformation} />} />
        </div>
    </>
);

// Default
export const Default = Template.bind({});

Default.args = {
    children: 'Button',
    disabled: false,
};

// Disabled
export const Disabled = MultiVariantTemplate.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
};

Disabled.argTypes = {
    variant: {
        control: false,
    },
    size: {
        control: false,
    },
};

// Primary
export const Primary = MultiVariantTemplate.bind({});

Primary.args = {
    ...Default.args,
    color: 'primary',
};

Primary.argTypes = {
    variant: {
        control: false,
    },
    size: {
        control: false,
    },
};

// Success
export const Success = MultiVariantTemplate.bind({});

Success.args = {
    ...Default.args,
    color: 'success',
};

Success.argTypes = {
    variant: {
        control: false,
    },
    size: {
        control: false,
    },
};

// Warning
export const Warning = MultiVariantTemplate.bind({});

Warning.args = {
    ...Default.args,
    color: 'warning',
};

Warning.argTypes = {
    variant: {
        control: false,
    },
    size: {
        control: false,
    },
};

// Error
export const Error = MultiVariantTemplate.bind({});

Error.args = {
    ...Default.args,
    color: 'error',
};

Error.argTypes = {
    variant: {
        control: false,
    },
    size: {
        control: false,
    },
};

// Error
export const Grey = MultiVariantTemplate.bind({});

Grey.args = {
    ...Default.args,
    color: 'grey',
};

Grey.argTypes = {
    variant: {
        control: false,
    },
    size: {
        control: false,
    },
};

// Sizes
export const Size = MultiSizeTemplate.bind({});

Size.args = {
    ...Default.args,
};

Size.argTypes = {
    size: {
        control: false,
    },
};

// Block
export const Block = MultiSizeTemplate.bind({});

Block.args = {
    ...Default.args,
    block: true,
};

Block.argTypes = {
    size: {
        control: false,
    },
};

// Icons
export const Icons = IconTemplate.bind({});

Icons.args = {
    ...Default.args,
};
