import { ComponentProps, useState, useEffect } from 'react';
import { Story, Meta } from '@storybook/react';

import { Checkbox } from './Checkbox';

export default {
    title: 'Components/Checkbox',
    component: Checkbox,
} as Meta;

/* Stories */

const Template: Story<ComponentProps<typeof Checkbox>> = (args) => {
    const { value, children, onChange, ...otherArgs } = args;

    const [activeValue, setActiveValue] = useState<boolean>(value);

    useEffect(() => {
        setActiveValue(value);
    }, [value]);

    return (
        <div style={{ width: '20rem' }}>
            <Checkbox
                value={activeValue}
                onChange={(value) => {
                    setActiveValue(value);
                    onChange(value);
                }}
                {...otherArgs}
            >
                {children}
            </Checkbox>
        </div>
    );
};

export const Default = Template.bind({});

Default.args = {
    value: false,
    disabled: false,
    children: 'Content',
};

export const Disabled = Template.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
    children: 'Content',
};

export const Checked = Template.bind({});

Checked.args = {
    ...Default.args,
    value: true,
    children: 'Content',
};

export const Indeterminate = Template.bind({});

Indeterminate.args = {
    ...Default.args,
    value: true,
    indeterminate: true,
    children: 'Content',
};

export const Error = Template.bind({});

Error.args = {
    ...Default.args,
    value: true,
    valid: false,
    children: 'Content',
};

export const MultiLine = Template.bind({});

MultiLine.args = {
    ...Default.args,
    children: 'Multi-line content '.repeat(8),
};
