import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import dayjs from 'dayjs';

import { Datepicker } from './';

export default {
    title: 'Components/Datepicker',
    component: Datepicker,
    argTypes: {},
};

/* Stories */

const Template: Story<ComponentProps<typeof Datepicker>> = (args) => {
    const { value, onChange, ...otherArgs } = args;
    const [selectedValue, setSelectedValue] = useState(value);

    useEffect(() => {
        setSelectedValue(value);
    }, [value]);

    return (
        <Datepicker
            value={selectedValue}
            onChange={(newValue) => {
                setSelectedValue(newValue);
                onChange(newValue);
            }}
            {...otherArgs}
        />
    );
};

// Default
export const Default = Template.bind({});

Default.args = {
    value: dayjs(new Date()).format('MM/DD/YYYY'),
};

// Placeholder
export const Placeholder = Template.bind({});

Placeholder.args = {
    ...Default.args,
    placeholder: 'Select Date',
};

// Disabled
export const Disabled = Template.bind({});

Disabled.args = {
    ...Placeholder.args,
    disabled: true,
};

// Error
export const Error = Template.bind({});

Error.args = {
    ...Placeholder.args,
    valid: false,
};
