import { ComponentProps } from 'react';
import { Story, Meta } from '@storybook/react';

import { Button } from '../Button';
import { Icon } from '../Icon';
import { Dropdown } from '.';

const mdiInformation =
    'M13,9H11V7H13M13,17H11V11H13M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2Z';
const mdiChevronRight = 'M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6-6-6z';

export default {
    title: 'Components/Dropdown',
    component: Dropdown,
    subcomponents: {
        Trigger: Dropdown.Trigger,
        Content: Dropdown.Content,
        Label: Dropdown.Label,
        Item: Dropdown.Item,
        Seperator: Dropdown.Seperator,
        SubMenu: Dropdown.SubMenu,
        SubMenuContent: Dropdown.SubMenuContent,
        SubMenuTrigger: Dropdown.SubMenuTrigger,
    },
    parameters: {
        layout: 'centered',
    },
} as Meta;

/* Stories */
const Template: Story<ComponentProps<typeof Dropdown>> = (args) => {
    return (
        <Dropdown {...args}>
            <Dropdown.Trigger>
                <Button>
                    <Icon path={mdiInformation} />
                </Button>
            </Dropdown.Trigger>
            <Dropdown.Content side="bottom">
                <Dropdown.Label>Edit</Dropdown.Label>
                <Dropdown.Item>Edit Settings</Dropdown.Item>
                <Dropdown.Item>Edit Permissions</Dropdown.Item>
                <Dropdown.SubMenu>
                    <Dropdown.SubMenuTrigger>
                        Additional Settings
                        <Icon
                            style={{
                                marginLeft: 'auto',
                            }}
                            path={mdiChevronRight}
                        />
                    </Dropdown.SubMenuTrigger>
                    <Dropdown.SubMenuContent>
                        <Dropdown.Item>Edit Settings</Dropdown.Item>
                        <Dropdown.Item>Edit Permissions</Dropdown.Item>
                    </Dropdown.SubMenuContent>
                </Dropdown.SubMenu>
                <Dropdown.Seperator />
                <Dropdown.Label>Actions</Dropdown.Label>
                <Dropdown.Item disabled={true}>Export Database</Dropdown.Item>
                <Dropdown.Item>Print Metadata</Dropdown.Item>
            </Dropdown.Content>
        </Dropdown>
    );
};

// Default
export const Default = Template.bind({});
Default.args = {};
