import { ReactNode } from 'react';
import { Root } from '@radix-ui/react-dropdown-menu';

export interface DropdownProps {
    /** Dropdown Trigger and Content */
    children: ReactNode;

    /** Boolean to control the state of the dropdown */
    open?: boolean;

    /** Callback that is triggered when the dropdown is opened */
    onOpen?: () => void;

    /** Callback that is triggered when the dropdown is closed */
    onClose?: () => void;
}

/**
 * Dropdown component
 */
export const Dropdown = (props: DropdownProps): JSX.Element => {
    const { children, open, onOpen = () => null, onClose = () => null } = props;

    return (
        <Root
            open={open}
            onOpenChange={(open) => {
                if (open) {
                    onOpen();
                } else {
                    onClose();
                }
            }}
        >
            {children}
        </Root>
    );
};
