import { ReactNode, forwardRef, ForwardedRef } from 'react';
import { Trigger } from '@radix-ui/react-dropdown-menu';

export interface DropdownTriggerProps {
    /** Content to act as the popover trigger */
    children: ReactNode;
}

/**
 * DropdownTrigger component
 */
const _DropdownTrigger = (
    props: DropdownTriggerProps,
    ref: ForwardedRef<HTMLButtonElement>,
): JSX.Element => {
    const { children } = props;

    return (
        <Trigger ref={ref} asChild={true}>
            {children}
        </Trigger>
    );
};

export const DropdownTrigger = forwardRef(_DropdownTrigger) as (
    props: DropdownTriggerProps & {
        ref?: ForwardedRef<HTMLButtonElement>;
    },
) => ReturnType<typeof _DropdownTrigger>;
