import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { FileDropzone } from './FileDropzone';

export default {
    title: 'Components/FileDropzone',
    component: FileDropzone,
    argTypes: {},
};

/* Stories */
const Template: Story<ComponentProps<typeof FileDropzone>> = (args) => {
    const { value, onChange, ...otherArgs } = args;
    const [selectedValues, setSelectedValues] = useState(value);

    useEffect(() => {
        setSelectedValues(value);
    }, [value]);

    return (
        <FileDropzone
            value={selectedValues}
            onChange={(newValues) => {
                setSelectedValues(newValues);
                onChange(newValues);
            }}
            {...otherArgs}
        />
    );
};

// Default
export const Default = Template.bind({});

Default.args = {
    onChange: () => null,
};

export const Disabled = Template.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
};

export const Error = Template.bind({});

Error.args = {
    ...Default.args,
    valid: false,
};

export const Multiple = Template.bind({});

Multiple.args = {
    ...Default.args,
    multiple: true,
};
