import { Form, FormProps } from './Form';
import { FormGroup, FormGroupProps } from './FormGroup';
import { FormDescription, FormDescriptionProps } from './FormDescription';
import { FormError, FormErrorProps } from './FormError';
import { FormField, FormFieldProps } from './FormField';
import { FormLabel, FormLabelProps } from './FormLabel';

const FormNameSpace = Object.assign(Form, {
    Group: FormGroup,
    Field: FormField,
    Label: FormLabel,
    Error: FormError,
    Description: FormDescription,
});

export type {
    FormProps,
    FormGroupProps,
    FormFieldProps,
    FormLabelProps,
    FormErrorProps,
    FormDescriptionProps,
};
export { FormNameSpace as Form };
