import { ComponentPropsWithRef } from 'react';
import { Icon as MdiIcon } from '@mdi/react';

import { styled } from '../../stitches.config';

const StyledIcon = styled(MdiIcon, {
    display: 'inline-block',
    height: '1em',
    width: '1em',
});

export type IconProps = ComponentPropsWithRef<typeof MdiIcon>;

export const Icon = (props: IconProps): JSX.Element => {
    return <StyledIcon {...props} />;
};
