import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { Input } from './';

export default {
    title: 'Components/Input',
    component: Input,
    argTypes: {},
};

/* Stories */
const Template: Story<ComponentProps<typeof Input>> = (args) => {
    const { value, onChange, ...otherArgs } = args;

    const [activeValue, setActiveValue] = useState<string | number>(value);

    useEffect(() => {
        setActiveValue(value);
    }, [value]);

    return (
        <Input
            value={activeValue}
            onChange={(value) => {
                setActiveValue(value);
                onChange(value);
            }}
            {...otherArgs}
        />
    );
};

const MultiSizeTemplate: Story<ComponentProps<typeof Input>> = (args) => (
    <>
        <div
            style={{ display: 'flex', flexDirection: 'column', gap: '0.5rem' }}
        >
            <Input size="sm" {...args} />
            <Input size="md" {...args} />
            <Input size="lg" {...args} />
        </div>
    </>
);

// Default
export const Default = Template.bind({});

Default.args = {
    value: '',
    placeholder: undefined,
    disabled: false,
    valid: true,
};

// Placeholder
export const Placeholder = Template.bind({});

Placeholder.args = {
    ...Default.args,
    placeholder: 'Enter your name',
};

// Disabled
export const Disabled = Template.bind({});

Disabled.args = {
    ...Placeholder.args,
    disabled: true,
};

// Error
export const Error = Template.bind({});

Error.args = {
    ...Placeholder.args,
    valid: false,
};

// number
export const Number = Template.bind({});

Number.args = {
    ...Default.args,
    type: 'number',
};

// size
export const Size = MultiSizeTemplate.bind({});

Size.args = {
    ...Placeholder.args,
};

Size.argTypes = {
    size: {
        control: false,
    },
};
