import { ReactNode, forwardRef, ForwardedRef } from 'react';
import { DialogClose } from '@radix-ui/react-dialog';

export interface ModalCloseProps {
    /** Content to act as the modal close */
    children: ReactNode;
}

/**
 * ModalClose Component
 */
const _ModalClose = (
    props: ModalCloseProps,
    ref: ForwardedRef<HTMLButtonElement>,
): JSX.Element => {
    const { children } = props;

    return (
        <DialogClose asChild={true} ref={ref}>
            {children}
        </DialogClose>
    );
};

export const ModalClose = forwardRef(_ModalClose) as (
    props: ModalCloseProps & {
        ref?: ForwardedRef<HTMLButtonElement>;
    },
) => ReturnType<typeof _ModalClose>;
