import {
    ComponentPropsWithRef,
    ReactNode,
    forwardRef,
    ForwardedRef,
} from 'react';

import { styled } from '../../stitches.config';

const StyledContainer = styled('div', {
    borderTopWidth: '$default',
    borderColor: `$grey-4`,
    margin: '$4 $4 0 $4',
    padding: '$4 0 0 0',
    display: 'flex',
    justifyContent: 'flex-end',
    gap: '$2',
});

export interface ModalFooterProps extends ComponentPropsWithRef<'div'> {
    /** Content to act as the modal footer */
    children: ReactNode;
}

/**
 * ModalFooter Component
 */
const _ModalFooter = (
    props: ModalFooterProps,
    ref: ForwardedRef<HTMLDivElement>,
): JSX.Element => {
    const { children, ...otherProps } = props;

    return (
        <StyledContainer ref={ref} {...otherProps}>
            {children}
        </StyledContainer>
    );
};

export const ModalFooter = forwardRef(_ModalFooter) as (
    props: ModalFooterProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _ModalFooter>;
