import { ReactNode, forwardRef, ForwardedRef } from 'react';
import { DialogTrigger } from '@radix-ui/react-dialog';

export interface ModalTriggerProps {
    /** Content to act as the modal trigger */
    children: ReactNode;
}

/**
 * ModalTrigger Component
 */
const _ModalTrigger = (
    props: ModalTriggerProps,
    ref: ForwardedRef<HTMLButtonElement>,
): JSX.Element => {
    const { children } = props;

    return (
        <DialogTrigger ref={ref} asChild={true}>
            {children}
        </DialogTrigger>
    );
};

export const ModalTrigger = forwardRef(_ModalTrigger) as (
    props: ModalTriggerProps & {
        ref?: ForwardedRef<HTMLButtonElement>;
    },
) => ReturnType<typeof _ModalTrigger>;
