import { Modal, ModalProps } from './Modal';
import { ModalBody, ModalBodyProps } from './ModalBody';
import { ModalContent, ModalContentProps } from './ModalContent';
import { ModalClose, ModalCloseProps } from './ModalClose';
import { ModalFooter, ModalFooterProps } from './ModalFooter';

import { ModalHeader, ModalHeaderProps } from './ModalHeader';
import { ModalTrigger, ModalTriggerProps } from './ModalTrigger';

const ModalNameSpace = Object.assign(Modal, {
    Body: ModalBody,
    Content: ModalContent,
    Close: ModalClose,
    Footer: ModalFooter,
    Header: ModalHeader,
    Trigger: ModalTrigger,
});

export type {
    ModalProps,
    ModalBodyProps,
    ModalContentProps,
    ModalCloseProps,
    ModalFooterProps,
    ModalHeaderProps,
    ModalTriggerProps,
};
export { ModalNameSpace as Modal };
