import { ComponentPropsWithoutRef, ReactNode } from 'react';
import { styled, theme } from '../../stitches.config';

import { Portal } from '../Portal';

const StyledContainer = styled('div', {
    position: 'fixed',
    maxHeight: '100%',
    overflow: 'auto',
    display: 'flex',
    flexDirection: 'column',
    gap: theme.space['2'],
    padding: theme.space['3'],
    zIndex: '60',
    variants: {
        position: {
            'top-right': {
                top: theme.space['0'],
                right: theme.space['0'],
            },
            'top-left': {
                top: theme.space['0'],
                left: theme.space['0'],
            },
            'bottom-right': {
                right: theme.space['0'],
                bottom: theme.space['0'],
            },
            'bottom-left': {
                left: theme.space['0'],
                bottom: theme.space['0'],
            },
        },
    },
});

export interface NotificationContainerProps
    extends ComponentPropsWithoutRef<'div'> {
    /** Content to render the notifications in */
    children: ReactNode;
    /** Container to render the notifications in */
    container?: HTMLElement | null;
    /** Position of the notifications */
    position?: 'top-right' | 'top-left' | 'bottom-right' | 'bottom-left';
}

export const NotificationContainer = (
    props: NotificationContainerProps,
): JSX.Element => {
    const {
        children,
        container,
        position = 'top-right',
        ...otherProps
    } = props;

    return (
        <Portal container={container}>
            <StyledContainer position={position} {...otherProps}>
                {children}
            </StyledContainer>
        </Portal>
    );
};
