import { ComponentPropsWithoutRef } from 'react';

import { createTheme } from '../../stitches.config';

export interface OverrideProps extends ComponentPropsWithoutRef<'div'> {
    /** Theme to override the child components */
    theme: ReturnType<typeof createTheme>;
}

export const Override = (props: OverrideProps): JSX.Element => {
    const {
        children,
        theme = createTheme({}),
        className,
        ...otherProps
    } = props;

    return (
        <div
            className={`${theme} ${className ? className : ''}`}
            {...otherProps}
        >
            {children}
        </div>
    );
};
