import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { PhoneNumberPicker } from './';

export default {
    title: 'Components/PhoneNumberPicker',
    component: PhoneNumberPicker,
    argTypes: {},
};

/* Stories */
const Template: Story<ComponentProps<typeof PhoneNumberPicker>> = (args) => {
    const { value, onChange, ...otherArgs } = args;

    const [activeValue, setActiveValue] = useState(value);

    useEffect(() => {
        setActiveValue(value);
    }, [value]);

    return (
        <PhoneNumberPicker
            value={activeValue}
            onChange={(value) => {
                setActiveValue(value);
                onChange(value);
            }}
            {...otherArgs}
        />
    );
};

const MultiSizeTemplate: Story<ComponentProps<typeof PhoneNumberPicker>> = (
    args,
) => (
    <>
        <div className="flex flex-col gap-y-2">
            <PhoneNumberPicker size="sm" {...args} />
            <PhoneNumberPicker size="md" {...args} />
            <PhoneNumberPicker size="lg" {...args} />
        </div>
    </>
);

// Default
export const Default = Template.bind({});

Default.args = {
    value: '',
    placeholder: undefined,
    disabled: false,
    valid: true,
};

// Placeholder
export const Placeholder = Template.bind({});

Placeholder.args = {
    ...Default.args,
    placeholder: 'Enter phone number',
};

// Disabled
export const Disabled = Template.bind({});

Disabled.args = {
    ...Placeholder.args,
    disabled: true,
};

// Error
export const Error = Template.bind({});

Error.args = {
    ...Placeholder.args,
    valid: false,
};

// number
export const Number = Template.bind({});

Number.args = {
    ...Default.args,
    type: 'number',
};

// size
export const Size = MultiSizeTemplate.bind({});

Size.args = {
    ...Placeholder.args,
};

Size.argTypes = {
    size: {
        control: false,
    },
};
